/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jdbi3.strategies;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jdbi3.strategies.StatementNameStrategy;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.statement.StatementContext;

public enum DefaultNameStrategy implements StatementNameStrategy
{
    CHECK_EMPTY{

        @Override
        public String getStatementName(StatementContext statementContext) {
            String rawSql = statementContext.getRawSql();
            return rawSql == null || rawSql.isEmpty() ? "sql.empty" : null;
        }
    }
    ,
    SQL_OBJECT{

        @Override
        public String getStatementName(StatementContext statementContext) {
            ExtensionMethod extensionMethod = statementContext.getExtensionMethod();
            if (extensionMethod != null) {
                return MetricRegistry.name((Class)extensionMethod.getType(), (String[])new String[]{extensionMethod.getMethod().getName()});
            }
            return null;
        }
    }
    ,
    NAIVE_NAME{

        @Override
        public String getStatementName(StatementContext statementContext) {
            return statementContext.getRawSql();
        }
    }
    ,
    CONSTANT_SQL_RAW{

        @Override
        public String getStatementName(StatementContext statementContext) {
            return "sql.raw";
        }
    };

}

