/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.jersey31;

import com.codahale.metrics.Clock;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SharedMetricRegistries;
import io.dropwizard.metrics.jersey31.InstrumentedResourceMethodApplicationListener;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import java.util.function.Supplier;

public class MetricsFeature
implements Feature {
    private final MetricRegistry registry;
    private final Clock clock;
    private final boolean trackFilters;
    private final Supplier<Reservoir> reservoirSupplier;

    public MetricsFeature(MetricRegistry registry) {
        this(registry, Clock.defaultClock());
    }

    public MetricsFeature(MetricRegistry registry, Supplier<Reservoir> reservoirSupplier) {
        this(registry, Clock.defaultClock(), false, reservoirSupplier);
    }

    public MetricsFeature(MetricRegistry registry, Clock clock) {
        this(registry, clock, false);
    }

    public MetricsFeature(MetricRegistry registry, Clock clock, boolean trackFilters) {
        this(registry, clock, trackFilters, ExponentiallyDecayingReservoir::new);
    }

    public MetricsFeature(MetricRegistry registry, Clock clock, boolean trackFilters, Supplier<Reservoir> reservoirSupplier) {
        this.registry = registry;
        this.clock = clock;
        this.trackFilters = trackFilters;
        this.reservoirSupplier = reservoirSupplier;
    }

    public MetricsFeature(String registryName) {
        this(SharedMetricRegistries.getOrCreate((String)registryName));
    }

    public boolean configure(FeatureContext context) {
        context.register((Object)new InstrumentedResourceMethodApplicationListener(this.registry, this.clock, this.trackFilters, this.reservoirSupplier));
        return true;
    }
}

