/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.jetty12.ee10;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.ResponseMeteredLevel;
import io.dropwizard.metrics.jetty12.AbstractInstrumentedHandler;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.ee10.servlet.AsyncContextState;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletApiResponse;
import org.eclipse.jetty.ee10.servlet.ServletChannelState;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class InstrumentedEE10Handler
extends AbstractInstrumentedHandler {
    private AsyncListener listener;

    public InstrumentedEE10Handler(MetricRegistry registry) {
        super(registry, null);
    }

    public InstrumentedEE10Handler(MetricRegistry registry, String prefix) {
        super(registry, prefix, ResponseMeteredLevel.COARSE);
    }

    public InstrumentedEE10Handler(MetricRegistry registry, String prefix, ResponseMeteredLevel responseMeteredLevel) {
        super(registry, prefix, responseMeteredLevel);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.listener = new AsyncAttachingListener();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        long start;
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        if (servletContextRequest == null) {
            return super.handle(request, response, callback);
        }
        this.activeDispatches.inc();
        ServletChannelState state = servletContextRequest.getServletRequestState();
        if (state.isInitial()) {
            this.activeRequests.inc();
            start = Request.getTimeStamp((Request)request);
            state.addListener(this.listener);
        } else {
            start = System.currentTimeMillis();
            this.activeSuspended.dec();
            if (state.getState() == ServletChannelState.State.HANDLING) {
                this.asyncDispatches.mark();
            }
        }
        boolean handled = false;
        try {
            handled = super.handle(request, response, callback);
        }
        finally {
            long now = System.currentTimeMillis();
            long dispatched = now - start;
            this.activeDispatches.dec();
            this.dispatches.update(dispatched, TimeUnit.MILLISECONDS);
            if (state.isSuspended()) {
                this.activeSuspended.inc();
            } else if (state.isInitial()) {
                this.updateResponses(request, response, start, handled);
            }
        }
        return handled;
    }

    private class AsyncAttachingListener
    implements AsyncListener {
        private AsyncAttachingListener() {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getAsyncContext().addListener((AsyncListener)new InstrumentedAsyncListener());
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private class InstrumentedAsyncListener
    implements AsyncListener {
        private final long startTime = System.currentTimeMillis();

        InstrumentedAsyncListener() {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            InstrumentedEE10Handler.this.asyncTimeouts.mark();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
            AsyncContextState state = (AsyncContextState)event.getAsyncContext();
            ServletApiRequest request = (ServletApiRequest)state.getRequest();
            ServletApiResponse response = (ServletApiResponse)state.getResponse();
            InstrumentedEE10Handler.this.updateResponses(request.getRequest(), response.getResponse(), this.startTime, true);
            ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request.getRequest(), ServletContextRequest.class);
            ServletChannelState servletRequestState = servletContextRequest.getServletRequestState();
            if (!servletRequestState.isSuspended()) {
                InstrumentedEE10Handler.this.activeSuspended.dec();
            }
        }
    }
}

