/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.jetty12;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.ResponseMeteredLevel;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

public abstract class AbstractInstrumentedHandler
extends Handler.Wrapper {
    protected static final String NAME_REQUESTS = "requests";
    protected static final String NAME_DISPATCHES = "dispatches";
    protected static final String NAME_ACTIVE_REQUESTS = "active-requests";
    protected static final String NAME_ACTIVE_DISPATCHES = "active-dispatches";
    protected static final String NAME_ACTIVE_SUSPENDED = "active-suspended";
    protected static final String NAME_ASYNC_DISPATCHES = "async-dispatches";
    protected static final String NAME_ASYNC_TIMEOUTS = "async-timeouts";
    protected static final String NAME_1XX_RESPONSES = "1xx-responses";
    protected static final String NAME_2XX_RESPONSES = "2xx-responses";
    protected static final String NAME_3XX_RESPONSES = "3xx-responses";
    protected static final String NAME_4XX_RESPONSES = "4xx-responses";
    protected static final String NAME_5XX_RESPONSES = "5xx-responses";
    protected static final String NAME_GET_REQUESTS = "get-requests";
    protected static final String NAME_POST_REQUESTS = "post-requests";
    protected static final String NAME_HEAD_REQUESTS = "head-requests";
    protected static final String NAME_PUT_REQUESTS = "put-requests";
    protected static final String NAME_DELETE_REQUESTS = "delete-requests";
    protected static final String NAME_OPTIONS_REQUESTS = "options-requests";
    protected static final String NAME_TRACE_REQUESTS = "trace-requests";
    protected static final String NAME_CONNECT_REQUESTS = "connect-requests";
    protected static final String NAME_MOVE_REQUESTS = "move-requests";
    protected static final String NAME_OTHER_REQUESTS = "other-requests";
    protected static final String NAME_PERCENT_4XX_1M = "percent-4xx-1m";
    protected static final String NAME_PERCENT_4XX_5M = "percent-4xx-5m";
    protected static final String NAME_PERCENT_4XX_15M = "percent-4xx-15m";
    protected static final String NAME_PERCENT_5XX_1M = "percent-5xx-1m";
    protected static final String NAME_PERCENT_5XX_5M = "percent-5xx-5m";
    protected static final String NAME_PERCENT_5XX_15M = "percent-5xx-15m";
    protected static final Set<ResponseMeteredLevel> COARSE_METER_LEVELS = EnumSet.of(ResponseMeteredLevel.COARSE, ResponseMeteredLevel.ALL);
    protected static final Set<ResponseMeteredLevel> DETAILED_METER_LEVELS = EnumSet.of(ResponseMeteredLevel.DETAILED, ResponseMeteredLevel.ALL);
    protected final MetricRegistry metricRegistry;
    private String name;
    protected final String prefix;
    protected Timer requests;
    protected Timer dispatches;
    protected Counter activeRequests;
    protected Counter activeDispatches;
    protected Counter activeSuspended;
    protected Meter asyncDispatches;
    protected Meter asyncTimeouts;
    protected final ResponseMeteredLevel responseMeteredLevel;
    protected List<Meter> responses;
    protected Map<Integer, Meter> responseCodeMeters;
    protected Timer getRequests;
    protected Timer postRequests;
    protected Timer headRequests;
    protected Timer putRequests;
    protected Timer deleteRequests;
    protected Timer optionsRequests;
    protected Timer traceRequests;
    protected Timer connectRequests;
    protected Timer moveRequests;
    protected Timer otherRequests;

    protected AbstractInstrumentedHandler(MetricRegistry registry) {
        this(registry, null);
    }

    protected AbstractInstrumentedHandler(MetricRegistry registry, String prefix) {
        this(registry, prefix, ResponseMeteredLevel.COARSE);
    }

    protected AbstractInstrumentedHandler(MetricRegistry registry, String prefix, ResponseMeteredLevel responseMeteredLevel) {
        this.responseMeteredLevel = responseMeteredLevel;
        this.metricRegistry = registry;
        this.prefix = prefix;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void doStart() throws Exception {
        super.doStart();
        String prefix = this.getMetricPrefix();
        this.requests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_REQUESTS}));
        this.dispatches = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_DISPATCHES}));
        this.activeRequests = this.metricRegistry.counter(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_ACTIVE_REQUESTS}));
        this.activeDispatches = this.metricRegistry.counter(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_ACTIVE_DISPATCHES}));
        this.activeSuspended = this.metricRegistry.counter(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_ACTIVE_SUSPENDED}));
        this.asyncDispatches = this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_ASYNC_DISPATCHES}));
        this.asyncTimeouts = this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_ASYNC_TIMEOUTS}));
        this.responseCodeMeters = DETAILED_METER_LEVELS.contains(this.responseMeteredLevel) ? new ConcurrentHashMap() : Collections.emptyMap();
        this.getRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_GET_REQUESTS}));
        this.postRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_POST_REQUESTS}));
        this.headRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_HEAD_REQUESTS}));
        this.putRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PUT_REQUESTS}));
        this.deleteRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_DELETE_REQUESTS}));
        this.optionsRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_OPTIONS_REQUESTS}));
        this.traceRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_TRACE_REQUESTS}));
        this.connectRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_CONNECT_REQUESTS}));
        this.moveRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_MOVE_REQUESTS}));
        this.otherRequests = this.metricRegistry.timer(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_OTHER_REQUESTS}));
        if (COARSE_METER_LEVELS.contains(this.responseMeteredLevel)) {
            this.responses = Collections.unmodifiableList(Arrays.asList(this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_1XX_RESPONSES})), this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_2XX_RESPONSES})), this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_3XX_RESPONSES})), this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_4XX_RESPONSES})), this.metricRegistry.meter(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_5XX_RESPONSES}))));
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PERCENT_4XX_1M}), (Metric)new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of((double)AbstractInstrumentedHandler.this.responses.get(3).getOneMinuteRate(), (double)AbstractInstrumentedHandler.this.requests.getOneMinuteRate());
                }
            });
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PERCENT_4XX_5M}), (Metric)new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of((double)AbstractInstrumentedHandler.this.responses.get(3).getFiveMinuteRate(), (double)AbstractInstrumentedHandler.this.requests.getFiveMinuteRate());
                }
            });
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PERCENT_4XX_15M}), (Metric)new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of((double)AbstractInstrumentedHandler.this.responses.get(3).getFifteenMinuteRate(), (double)AbstractInstrumentedHandler.this.requests.getFifteenMinuteRate());
                }
            });
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PERCENT_5XX_1M}), (Metric)new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of((double)AbstractInstrumentedHandler.this.responses.get(4).getOneMinuteRate(), (double)AbstractInstrumentedHandler.this.requests.getOneMinuteRate());
                }
            });
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PERCENT_5XX_5M}), (Metric)new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of((double)AbstractInstrumentedHandler.this.responses.get(4).getFiveMinuteRate(), (double)AbstractInstrumentedHandler.this.requests.getFiveMinuteRate());
                }
            });
            this.metricRegistry.register(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PERCENT_5XX_15M}), (Metric)new RatioGauge(){

                public RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of((double)AbstractInstrumentedHandler.this.responses.get(4).getFifteenMinuteRate(), (double)AbstractInstrumentedHandler.this.requests.getFifteenMinuteRate());
                }
            });
        } else {
            this.responses = Collections.emptyList();
        }
    }

    protected void doStop() throws Exception {
        String prefix = this.getMetricPrefix();
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_REQUESTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_DISPATCHES}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_ACTIVE_REQUESTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_ACTIVE_DISPATCHES}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_ACTIVE_SUSPENDED}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_ASYNC_DISPATCHES}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_ASYNC_TIMEOUTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_1XX_RESPONSES}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_2XX_RESPONSES}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_3XX_RESPONSES}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_4XX_RESPONSES}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_5XX_RESPONSES}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_GET_REQUESTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_POST_REQUESTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_HEAD_REQUESTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PUT_REQUESTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_DELETE_REQUESTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_OPTIONS_REQUESTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_TRACE_REQUESTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_CONNECT_REQUESTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_MOVE_REQUESTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_OTHER_REQUESTS}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PERCENT_4XX_1M}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PERCENT_4XX_5M}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PERCENT_4XX_15M}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PERCENT_5XX_1M}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PERCENT_5XX_5M}));
        this.metricRegistry.remove(MetricRegistry.name((String)prefix, (String[])new String[]{NAME_PERCENT_5XX_15M}));
        if (this.responseCodeMeters != null) {
            this.responseCodeMeters.keySet().stream().map(sc -> MetricRegistry.name((String)this.getMetricPrefix(), (String[])new String[]{String.format("%d-responses", sc)})).forEach(arg_0 -> ((MetricRegistry)this.metricRegistry).remove(arg_0));
        }
        super.doStop();
    }

    protected Timer requestTimer(String method) {
        HttpMethod m = HttpMethod.fromString((String)method);
        if (m == null) {
            return this.otherRequests;
        }
        switch (m) {
            case GET: {
                return this.getRequests;
            }
            case POST: {
                return this.postRequests;
            }
            case PUT: {
                return this.putRequests;
            }
            case HEAD: {
                return this.headRequests;
            }
            case DELETE: {
                return this.deleteRequests;
            }
            case OPTIONS: {
                return this.optionsRequests;
            }
            case TRACE: {
                return this.traceRequests;
            }
            case CONNECT: {
                return this.connectRequests;
            }
            case MOVE: {
                return this.moveRequests;
            }
        }
        return this.otherRequests;
    }

    protected void updateResponses(Request request, Response response, long start, boolean isHandled) {
        if (isHandled) {
            this.mark(response.getStatus());
        } else {
            this.mark(404);
        }
        this.activeRequests.dec();
        long elapsedTime = System.currentTimeMillis() - start;
        this.requests.update(elapsedTime, TimeUnit.MILLISECONDS);
        this.requestTimer(request.getMethod()).update(elapsedTime, TimeUnit.MILLISECONDS);
    }

    protected void mark(int statusCode) {
        int responseStatus;
        if (DETAILED_METER_LEVELS.contains(this.responseMeteredLevel)) {
            this.getResponseCodeMeter(statusCode).mark();
        }
        if (COARSE_METER_LEVELS.contains(this.responseMeteredLevel) && (responseStatus = statusCode / 100) >= 1 && responseStatus <= 5) {
            this.responses.get(responseStatus - 1).mark();
        }
    }

    protected Meter getResponseCodeMeter(int statusCode) {
        return this.responseCodeMeters.computeIfAbsent(statusCode, sc -> this.metricRegistry.meter(MetricRegistry.name((String)this.getMetricPrefix(), (String[])new String[]{String.format("%d-responses", sc)})));
    }

    protected String getMetricPrefix() {
        return this.prefix == null ? MetricRegistry.name(this.getHandler().getClass(), (String[])new String[]{this.name}) : MetricRegistry.name((String)this.prefix, (String[])new String[]{this.name});
    }
}

