/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import java.util.Set;

public abstract class DeployParser {
    private static final char SINGLE_QUOTE = '\'';
    private static final char COLON = ':';
    private static final char UNDERSCORE = '_';
    private static final char OPEN_SQUARE_BRACKET = '[';
    private static final char CLOSE_SQUARE_BRACKET = ']';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char BACK_QUOTE = '`';
    private static final char PERIOD = '.';
    private static final char OPEN_BRACKET = '(';
    boolean encrypted;
    private String source;
    private StringBuilder sb;
    private int sourceLength;
    private int pos;
    String priorWord;
    String word;
    private char wordTerminator;
    private StringBuilder wordBuffer;

    protected abstract String convertWord();

    public abstract String getDeployWord(String var1);

    public abstract Set<String> getIncludes();

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public String parse(String source) {
        if (source == null) {
            return null;
        }
        this.pos = -1;
        this.source = source;
        this.sourceLength = source.length();
        this.sb = new StringBuilder(source.length() + 20);
        while (this.nextWord()) {
            if (this.skipWordConvert()) {
                this.sb.append(this.word);
                this.priorWord = this.word;
            } else {
                String deployWord = this.convertWord();
                this.sb.append(deployWord);
                this.priorWord = deployWord;
            }
            if (this.pos >= this.sourceLength) continue;
            if (this.wordTerminator != '(') {
                this.sb.append(this.wordTerminator);
            }
            if (this.wordTerminator != '\'') continue;
            this.readLiteral();
        }
        return this.sb.toString();
    }

    boolean skipWordConvert() {
        return false;
    }

    private boolean nextWord() {
        if (!this.findWordStart()) {
            return false;
        }
        this.wordBuffer = new StringBuilder();
        this.wordBuffer.append(this.source.charAt(this.pos));
        while (++this.pos < this.sourceLength) {
            char ch = this.source.charAt(this.pos);
            if (this.isWordPart(ch)) {
                this.wordBuffer.append(ch);
                continue;
            }
            this.wordTerminator = ch;
            break;
        }
        this.word = this.wordBuffer.toString();
        return true;
    }

    private boolean findWordStart() {
        while (++this.pos < this.sourceLength) {
            char ch = this.source.charAt(this.pos);
            if (ch == '\'') {
                this.sb.append(ch);
                this.readLiteral();
                continue;
            }
            if (ch == ':') {
                this.sb.append(ch);
                this.readNamedParameter();
                continue;
            }
            if (this.isWordStart(ch)) {
                return true;
            }
            this.sb.append(ch);
        }
        return false;
    }

    private void readLiteral() {
        while (++this.pos < this.sourceLength) {
            char ch = this.source.charAt(this.pos);
            this.sb.append(ch);
            if (ch != '\'') continue;
            break;
        }
    }

    private void readNamedParameter() {
        while (++this.pos < this.sourceLength) {
            char ch = this.source.charAt(this.pos);
            this.sb.append(ch);
            if (!Character.isWhitespace(ch) && ch != ',') continue;
            break;
        }
    }

    private boolean isWordPart(char ch) {
        if (ch == '(') {
            this.wordBuffer.append(ch);
            return false;
        }
        return Character.isLetterOrDigit(ch) || ch == '_' || ch == '.' || ch == '\"' || ch == ']' || ch == '`';
    }

    private boolean isWordStart(char ch) {
        return Character.isLetter(ch) || ch == '_' || ch == '\"' || ch == '[' || ch == '`';
    }
}

