/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.annotation.Platform;

public final class IndexDefinition {
    private final String[] columns;
    private final String name;
    private final Platform[] platforms;
    private final boolean unique;
    private final boolean concurrent;
    private final String definition;

    public IndexDefinition(String[] columns, String name, boolean unique, Platform[] platforms, boolean concurrent, String definition) {
        this.columns = columns;
        this.unique = unique;
        this.name = name;
        this.platforms = platforms;
        this.concurrent = concurrent;
        this.definition = definition;
    }

    public IndexDefinition(String name, String[] columns) {
        this.columns = columns;
        this.unique = true;
        this.name = name;
        this.platforms = null;
        this.concurrent = false;
        this.definition = null;
    }

    public boolean isUniqueConstraint() {
        return this.unique && !this.concurrent && this.noDefinition() && this.noColumnFormulas();
    }

    private boolean noDefinition() {
        return this.definition == null || this.definition.isEmpty();
    }

    private boolean noColumnFormulas() {
        for (String column : this.columns) {
            if (!column.contains("(")) continue;
            return false;
        }
        return true;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getName() {
        return this.name;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public Platform[] getPlatforms() {
        return this.platforms;
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }

    public String getDefinition() {
        return this.definition;
    }
}

