/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.dto;

import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.dto.DtoMeta;
import io.ebeaninternal.server.dto.DtoMetaConstructor;
import io.ebeaninternal.server.dto.DtoMetaProperty;
import io.ebeaninternal.server.type.TypeManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

final class DtoMetaBuilder {
    private final TypeManager typeManager;
    private final Class<?> dtoType;
    private final List<DtoMetaProperty> properties = new ArrayList<DtoMetaProperty>();
    private final List<DtoMetaConstructor> constructorList = new ArrayList<DtoMetaConstructor>();

    DtoMetaBuilder(Class<?> dtoType, TypeManager typeManager) {
        this.dtoType = dtoType;
        this.typeManager = typeManager;
    }

    DtoMeta build() {
        this.readConstructors();
        this.readProperties();
        return new DtoMeta(this.dtoType, this.constructorList, this.properties);
    }

    private void readProperties() {
        for (Method method : this.dtoType.getMethods()) {
            if (!DtoMetaBuilder.includeMethod(method)) continue;
            try {
                String name = DtoMetaBuilder.propertyName(method.getName());
                this.properties.add(new DtoMetaProperty(this.typeManager, this.dtoType, method, name));
            }
            catch (Exception e) {
                CoreLog.log.debug("exclude on " + this.dtoType + " method " + method, (Throwable)e);
            }
        }
    }

    static String propertyName(String methodName) {
        if (DtoMetaBuilder.isTraditionalSetterMethod(methodName)) {
            String name = methodName.substring(3);
            return Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return methodName;
    }

    private static boolean isTraditionalSetterMethod(String methodName) {
        return methodName.startsWith("set") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3));
    }

    static boolean includeMethod(Method method) {
        String name = method.getName();
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && method.getParameterTypes().length == 1 && !name.equals("wait") && !name.equals("equals");
    }

    private void readConstructors() {
        for (Constructor<?> constructor : this.dtoType.getConstructors()) {
            try {
                this.constructorList.add(new DtoMetaConstructor(this.typeManager, constructor, this.dtoType));
            }
            catch (Exception e) {
                CoreLog.log.debug("exclude on " + this.dtoType + " constructor " + constructor, (Throwable)e);
            }
        }
    }
}

