/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.config.CurrentTenantProvider;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import io.ebeaninternal.server.transaction.TransactionFactory;
import io.ebeaninternal.server.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.PersistenceException;

class TransactionFactoryTenant
extends TransactionFactory {
    final DataSourceSupplier dataSourceSupplier;
    final CurrentTenantProvider tenantProvider;

    TransactionFactoryTenant(TransactionManager manager, DataSourceSupplier dataSourceSupplier, CurrentTenantProvider tenantProvider) {
        super(manager);
        this.dataSourceSupplier = dataSourceSupplier;
        this.tenantProvider = tenantProvider;
    }

    @Override
    public SpiTransaction createReadOnlyTransaction(Object tenantId) {
        return this.create(false, tenantId);
    }

    @Override
    public final SpiTransaction createTransaction(boolean explicit, int isolationLevel) {
        SpiTransaction t = this.create(explicit, null);
        return this.setIsolationLevel(t, explicit, isolationLevel);
    }

    private SpiTransaction create(boolean explicit, Object tenantId) {
        Connection connection = null;
        try {
            if (tenantId == null) {
                tenantId = this.tenantProvider.currentId();
            }
            connection = this.dataSourceSupplier.getConnection(tenantId);
            SpiTransaction transaction = this.manager.createTransaction(explicit, connection);
            transaction.setTenantId(tenantId);
            return transaction;
        }
        catch (PersistenceException ex) {
            JdbcClose.close(connection);
            throw ex;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }
}

