/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.text.TextException;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

final class ScalarTypeInteger
extends ScalarTypeBase<Integer> {
    ScalarTypeInteger() {
        super(Integer.class, true, 4);
    }

    public void bind(DataBinder binder, Integer value) throws SQLException {
        if (value == null) {
            binder.setNull(4);
        } else {
            binder.setInt(value.intValue());
        }
    }

    public Integer read(DataReader reader) throws SQLException {
        return reader.getInt();
    }

    public Integer readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return dataInput.readInt();
    }

    public void writeData(DataOutput dataOutput, Integer value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(value);
        }
    }

    public long asVersion(Integer value) {
        return value.longValue();
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toInteger(value);
    }

    public Integer toBeanType(Object value) {
        return BasicTypeConverter.toInteger(value);
    }

    @Override
    public String format(Object value) {
        return String.valueOf(value);
    }

    public String formatValue(Integer v) {
        return v.toString();
    }

    public Integer parse(String value) {
        return Integer.valueOf(value);
    }

    public Integer convertFromMillis(long systemTimeMillis) {
        throw new TextException("Not Supported");
    }

    public boolean isDateTimeCapable() {
        return false;
    }

    public Integer jsonRead(JsonParser parser) throws IOException {
        return parser.getIntValue();
    }

    public void jsonWrite(JsonGenerator writer, Integer value) throws IOException {
        writer.writeNumber(value.intValue());
    }

    public DocPropertyType getDocType() {
        return DocPropertyType.INTEGER;
    }
}

