/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

final class ScalarTypeShort
extends ScalarTypeBase<Short> {
    ScalarTypeShort() {
        super(Short.class, true, 5);
    }

    public void bind(DataBinder binder, Short value) throws SQLException {
        if (value == null) {
            binder.setNull(5);
        } else {
            binder.setShort(value.shortValue());
        }
    }

    public Short read(DataReader reader) throws SQLException {
        return reader.getShort();
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toShort(value);
    }

    public Short toBeanType(Object value) {
        return BasicTypeConverter.toShort(value);
    }

    public String formatValue(Short v) {
        return v.toString();
    }

    public Short parse(String value) {
        return Short.valueOf(value);
    }

    public Short readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return dataInput.readShort();
    }

    public void writeData(DataOutput dataOutput, Short value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeShort(value.shortValue());
        }
    }

    public Short jsonRead(JsonParser parser) throws IOException {
        return parser.getShortValue();
    }

    public void jsonWrite(JsonGenerator writer, Short value) throws IOException {
        writer.writeNumber(value.shortValue());
    }

    public DocPropertyType getDocType() {
        return DocPropertyType.SHORT;
    }
}

