/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.ebean.ModifyAwareType;
import io.ebean.annotation.MutationDetection;
import io.ebeaninternal.server.deploy.meta.DeployBeanProperty;

final class TypeJsonManager {
    private final boolean postgres;
    private final ObjectMapper objectMapper;
    private final MutationDetection mutationDetection;

    TypeJsonManager(boolean postgres, Object objectMapper, MutationDetection mutationDetection) {
        this.postgres = postgres;
        this.objectMapper = (ObjectMapper)objectMapper;
        this.mutationDetection = mutationDetection;
    }

    MutationDetection mutationDetection() {
        return this.mutationDetection;
    }

    ObjectMapper objectMapper() {
        return this.objectMapper;
    }

    boolean keepSource(DeployBeanProperty prop) {
        if (prop.getMutationDetection() == MutationDetection.SOURCE) {
            return true;
        }
        if (prop.getMutationDetection() == MutationDetection.DEFAULT) {
            prop.setMutationDetection(this.mutationDetection);
            return this.mutationDetection == MutationDetection.SOURCE;
        }
        return false;
    }

    String postgresType(int dbType) {
        if (this.postgres) {
            switch (dbType) {
                case 5001: {
                    return "json";
                }
                case 5002: {
                    return "jsonb";
                }
            }
        }
        return null;
    }

    static boolean checkIsDirty(Object value) {
        if (value instanceof ModifyAwareType) {
            return TypeJsonManager.checkModifyAware(value);
        }
        return true;
    }

    private static boolean checkModifyAware(Object value) {
        ModifyAwareType modifyAware = (ModifyAwareType)value;
        if (modifyAware.isMarkedDirty()) {
            modifyAware.setMarkedDirty(false);
            return true;
        }
        return false;
    }
}

