/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;

public class BaseDdlBuffer
implements DdlBuffer {
    protected final StringBuilder writer = new StringBuilder();

    @Override
    public boolean isEmpty() {
        return this.writer.length() == 0;
    }

    @Override
    public DdlBuffer appendWithSpace(String content) {
        if (content != null && !content.isEmpty()) {
            this.writer.append(" ").append(content);
        }
        return this;
    }

    @Override
    public DdlBuffer appendStatement(String content) {
        if (content != null && !content.isEmpty()) {
            this.writer.append(content);
            this.endOfStatement();
        }
        return this;
    }

    @Override
    public DdlBuffer append(String content) {
        this.writer.append(content);
        return this;
    }

    @Override
    public DdlBuffer append(String content, int space) {
        this.writer.append(content);
        this.appendSpace(space, content);
        return this;
    }

    protected void appendSpace(int max, String content) {
        int space = max - content.length();
        if (space > 0) {
            for (int i = 0; i < space; ++i) {
                this.append(" ");
            }
        }
        this.append(" ");
    }

    @Override
    public DdlBuffer endOfStatement() {
        this.writer.append(";\n");
        return this;
    }

    @Override
    public DdlBuffer end() {
        if (!this.isEmpty()) {
            this.writer.append("\n");
        }
        return this;
    }

    @Override
    public DdlBuffer newLine() {
        this.writer.append("\n");
        return this;
    }

    @Override
    public String getBuffer() {
        return this.writer.toString();
    }
}

