/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.util.StringHelper;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlAlterTable;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.BaseAlterTableWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DB2ColumnOptionsParser;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.Db2HistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.Column;
import java.util.ArrayList;
import java.util.List;

public class DB2Ddl
extends PlatformDdl {
    private static final String MOVE_TABLE = "CALL SYSPROC.ADMIN_MOVE_TABLE(CURRENT_SCHEMA,'%s','%s','%s','%s','','','','','','MOVE')";

    public DB2Ddl(DatabasePlatform platform) {
        super(platform);
        this.dropTableIfExists = "drop table ";
        this.dropSequenceIfExists = "drop sequence ";
        this.dropConstraintIfExists = "NOT USED";
        this.dropIndexIfExists = "NOT USED";
        this.identitySuffix = " generated by default as identity";
        this.columnSetNull = "drop not null";
        this.columnSetType = "set data type ";
        this.inlineUniqueWhenNullable = false;
        this.historyDdl = new Db2HistoryDdl();
    }

    @Override
    public String alterTableTablespace(String tablename, String tableSpace, String indexSpace, String lobSpace) {
        if (tableSpace == null) {
            return String.format(MOVE_TABLE, tablename.toUpperCase(), "USERSPACE1", "USERSPACE1", "USERSPACE1");
        }
        return String.format(MOVE_TABLE, tablename.toUpperCase(), tableSpace, indexSpace, lobSpace);
    }

    @Override
    public String alterTableAddUniqueConstraint(String tableName, String uqName, String[] columns, String[] nullableColumns) {
        if (nullableColumns == null || nullableColumns.length == 0) {
            return super.alterTableAddUniqueConstraint(tableName, uqName, columns, nullableColumns);
        }
        if (uqName == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder("create unique index ");
        sb.append(this.maxConstraintName(uqName)).append(" on ").append(tableName).append('(');
        for (int i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(columns[i]);
        }
        sb.append(") exclude null keys");
        return sb.toString();
    }

    @Override
    public void addTablespace(DdlBuffer apply, String tablespaceName, String indexTablespace, String lobTablespace) {
        apply.append(" in ").append(tablespaceName).append(" index in ").append(indexTablespace).append(" long in ").append(lobTablespace);
    }

    @Override
    public void alterTableAddColumn(DdlWrite writer, String tableName, Column column, boolean onHistoryTable, String defaultValue) {
        String convertedType = this.convert(column.getType());
        DdlBuffer buffer = this.alterTable(writer, tableName).append(this.addColumn, column.getName());
        buffer.append(convertedType);
        if (defaultValue != null) {
            buffer.append(" default ");
            buffer.append(defaultValue);
        }
        if (this.isTrue(column.isNotnull())) {
            buffer.appendWithSpace(this.columnNotNull);
        }
        if (!onHistoryTable && !StringHelper.isNull((String)column.getCheckConstraint())) {
            String ddl = this.alterTableAddCheckConstraint(tableName, column.getCheckConstraintName(), column.getCheckConstraint());
            writer.applyPostAlter().appendStatement(ddl);
        }
    }

    @Override
    public String alterTableDropForeignKey(String tableName, String fkName) {
        return this.alterTableDropConstraint(tableName, fkName);
    }

    @Override
    public String alterTableDropUniqueConstraint(String tableName, String uniqueConstraintName) {
        return this.alterTableDropConstraint(tableName, uniqueConstraintName) + "\n" + this.dropIndex(uniqueConstraintName, tableName);
    }

    private void assertNoSchema(String objName) {
        if (objName.indexOf(46) != -1) {
            throw new UnsupportedOperationException("Schemas are not yet supported. ObjectName: '" + objName + "'");
        }
    }

    @Override
    public String alterTableDropConstraint(String tableName, String constraintName) {
        this.assertNoSchema(tableName);
        StringBuilder sb = new StringBuilder(300);
        sb.append("delimiter $$\n").append("begin\n").append("if exists (select constname from syscat.tabconst where tabschema = current_schema and ucase(constname) = '").append(this.maxConstraintName(constraintName).toUpperCase()).append("' and ucase(tabname) = '").append(this.naming.normaliseTable(tableName).toUpperCase()).append("') then\n").append("  prepare stmt from 'alter table ").append(tableName).append(" drop constraint ").append(this.maxConstraintName(constraintName)).append("';\n").append("  execute stmt;\n").append("end if;\n").append("end$$");
        return sb.toString();
    }

    @Override
    public String dropIndex(String indexName, String tableName, boolean concurrent) {
        this.assertNoSchema(indexName);
        StringBuilder sb = new StringBuilder(300);
        sb.append("delimiter $$\n").append("begin\n").append("if exists (select indname from syscat.indexes where indschema = current_schema and ucase(indname) = '").append(this.maxConstraintName(indexName).toUpperCase()).append("') then\n").append("  prepare stmt from 'drop index ").append(this.maxConstraintName(indexName)).append("';\n").append("  execute stmt;\n").append("end if;\n").append("end$$");
        return sb.toString();
    }

    @Override
    public String dropSequence(String sequenceName) {
        this.assertNoSchema(sequenceName);
        StringBuilder sb = new StringBuilder(300);
        sb.append("delimiter $$\n");
        sb.append("begin\n");
        sb.append("if exists (select seqschema from syscat.sequences where seqschema = current_schema and ucase(seqname) = '").append(this.maxConstraintName(sequenceName).toUpperCase()).append("') then\n");
        sb.append("  prepare stmt from 'drop sequence ").append(this.maxConstraintName(sequenceName)).append("';\n");
        sb.append("  execute stmt;\n");
        sb.append("end if;\n");
        sb.append("end$$");
        return sb.toString();
    }

    @Override
    protected void alterColumnType(DdlWrite writer, AlterColumn alter) {
        String type = this.convert(alter.getType());
        DB2ColumnOptionsParser parser = new DB2ColumnOptionsParser(type);
        this.alterTable(writer, alter.getTableName()).append(this.alterColumn, alter.getColumnName()).append(this.columnSetType).append(parser.getType());
        if (parser.getInlineLength() != null) {
            this.alterTable(writer, alter.getTableName()).append(this.alterColumn, alter.getColumnName()).append("set").appendWithSpace(parser.getInlineLength());
        }
        if (parser.hasExtraOptions()) {
            this.alterTable(writer, alter.getTableName()).raw("-- ignored options for ").append(alter.getTableName()).append(".").append(alter.getColumnName()).append(": compact=").append(String.valueOf(parser.isCompact())).append(", logged=").append(String.valueOf(parser.isLogged()));
        }
    }

    @Override
    protected DdlAlterTable alterTable(DdlWrite writer, String tableName) {
        return writer.applyAlterTable(tableName, x$0 -> new Db2AlterTableWrite((String)x$0));
    }

    class Db2AlterTableWrite
    extends BaseAlterTableWrite {
        public Db2AlterTableWrite(String tableName) {
            super(tableName, DB2Ddl.this);
        }

        @Override
        protected List<BaseAlterTableWrite.AlterCmd> postProcessCommands(List<BaseAlterTableWrite.AlterCmd> cmds) {
            ArrayList<BaseAlterTableWrite.AlterCmd> ret = new ArrayList<BaseAlterTableWrite.AlterCmd>(cmds.size() + 1);
            boolean requiresReorg = false;
            for (BaseAlterTableWrite.AlterCmd cmd : cmds) {
                ret.add(cmd);
                if (requiresReorg || !this.checkReorg(cmd)) continue;
                requiresReorg = true;
            }
            if (requiresReorg) {
                ret.add(this.newRawCommand("call sysproc.admin_cmd('reorg table " + this.tableName() + "')"));
            }
            return ret;
        }

        private boolean checkReorg(BaseAlterTableWrite.AlterCmd cmd) {
            switch (cmd.getOperation()) {
                case "drop column": {
                    return true;
                }
                case "alter column": {
                    String alter = cmd.getAlternation();
                    return alter.equals("set not null") || alter.equals("drop not default") || alter.startsWith("set data type");
                }
            }
            return false;
        }
    }
}

