/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebeaninternal.dbmigration.migration.Column;
import java.util.ArrayList;
import java.util.List;

class WriteUniqueConstraint {
    private final List<Column> primaryKeys = new ArrayList<Column>();
    private final List<Column> uniqueKeys = new ArrayList<Column>();

    WriteUniqueConstraint(List<Column> columns) {
        for (Column column : columns) {
            if (Boolean.TRUE.equals(column.isPrimaryKey())) {
                this.primaryKeys.add(column);
            }
            if (!this.hasValue(column.getUnique()) && !this.hasValue(column.getUniqueOneToOne())) continue;
            this.uniqueKeys.add(column);
        }
    }

    boolean hasValue(String value) {
        return value != null && !value.trim().isEmpty();
    }

    public List<Column> uniqueKeys() {
        if (this.uniqueKeys.isEmpty() || this.primaryKeys.size() > 1) {
            return this.uniqueKeys;
        }
        for (Column primaryKey : this.primaryKeys) {
            this.uniqueKeys.remove(primaryKey);
        }
        return this.uniqueKeys;
    }
}

