/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebean.config.DatabaseConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.util.IOUtils;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlHandler;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.PlatformDdlBuilder;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.migration.ChangeSet;
import io.ebeaninternal.dbmigration.migration.ChangeSetType;
import io.ebeaninternal.dbmigration.migration.Migration;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformDdlWriter {
    private static final Logger logger = LoggerFactory.getLogger(PlatformDdlWriter.class);
    private final DatabaseConfig databaseConfig;
    private final PlatformDdl platformDdl;
    private final int lockTimeoutSeconds;

    public PlatformDdlWriter(DatabasePlatform platform, DatabaseConfig dbConfig, int lockTimeoutSeconds) {
        this.platformDdl = PlatformDdlBuilder.create(platform);
        this.databaseConfig = dbConfig;
        this.lockTimeoutSeconds = lockTimeoutSeconds;
    }

    public void processMigration(Migration dbMigration, DdlWrite writer, File writePath, String fullVersion) throws IOException {
        String lockSql;
        DdlHandler handler = this.handler();
        handler.generateProlog(writer);
        if (this.lockTimeoutSeconds > 0 && (lockSql = this.platformDdl.setLockTimeout(this.lockTimeoutSeconds)) != null) {
            writer.apply().append(lockSql).endOfStatement().newLine();
        }
        List<ChangeSet> changeSets = dbMigration.getChangeSet();
        for (ChangeSet changeSet : changeSets) {
            if (!this.isApply(changeSet)) continue;
            handler.generate(writer, changeSet);
        }
        handler.generateEpilog(writer);
        this.writePlatformDdl(writer, writePath, fullVersion);
    }

    private boolean isApply(ChangeSet changeSet) {
        return changeSet.getType() == ChangeSetType.APPLY && !changeSet.getChangeSetChildren().isEmpty();
    }

    protected void writePlatformDdl(DdlWrite writer, File resourcePath, String fullVersion) throws IOException {
        if (!writer.isApplyEmpty()) {
            try (Writer applyWriter = this.createWriter(resourcePath, fullVersion, ".sql");){
                this.writeApplyDdl(applyWriter, writer);
                applyWriter.flush();
            }
        }
    }

    protected Writer createWriter(File path, String fullVersion, String suffix) throws IOException {
        File applyFile = new File(path, fullVersion + suffix);
        return IOUtils.newWriter((File)applyFile);
    }

    protected void writeApplyDdl(Writer writer, DdlWrite ddl) throws IOException {
        String header = this.databaseConfig.getDdlHeader();
        if (header != null && !header.isEmpty()) {
            writer.append(header).append('\n');
        }
        ddl.writeApply(writer);
    }

    protected DdlHandler handler() {
        return this.platformDdl.createDdlHandler(this.databaseConfig);
    }

    public File subPath(File path, String suffix) {
        File subPath = new File(path, suffix);
        if (!subPath.exists() && !subPath.mkdirs()) {
            logger.error("failed to create directories for " + subPath.getAbsolutePath());
        }
        return subPath;
    }
}

