/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.util.StringHelper;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlBuffer;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlHelp;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.MySqlHistoryDdl;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;
import io.ebeaninternal.dbmigration.migration.AlterColumn;
import io.ebeaninternal.dbmigration.migration.Column;

public class MySqlDdl
extends PlatformDdl {
    private static final boolean USE_CHECK_CONSTRAINT = Boolean.getBoolean("ebean.mysql.useCheckConstraint");
    private final boolean useMigrationStoredProcedures;

    public MySqlDdl(DatabasePlatform platform) {
        super(platform);
        this.alterColumn = "alter";
        this.dropUniqueConstraint = "drop index";
        this.historyDdl = new MySqlHistoryDdl();
        this.inlineComments = true;
        this.useMigrationStoredProcedures = platform.useMigrationStoredProcedures();
    }

    @Override
    public String dropIndex(String indexName, String tableName, boolean concurrent) {
        return "drop index " + this.maxConstraintName(indexName) + " on " + this.quote(tableName);
    }

    @Override
    public void alterTableDropColumn(DdlWrite writer, String tableName, String columnName) {
        if (this.useMigrationStoredProcedures) {
            this.alterTable(writer, tableName).raw("CALL usp_ebean_drop_column('").append(this.naming.normaliseTable(tableName)).append("', '").append(this.naming.normaliseColumn(columnName)).append("')");
        } else {
            super.alterTableDropColumn(writer, tableName, columnName);
        }
    }

    @Override
    public String alterTableDropForeignKey(String tableName, String fkName) {
        return "alter table " + this.quote(tableName) + " drop foreign key " + this.maxConstraintName(fkName);
    }

    @Override
    public String createCheckConstraint(String ckName, String checkConstraint) {
        if (USE_CHECK_CONSTRAINT) {
            return super.createCheckConstraint(ckName, checkConstraint);
        }
        return null;
    }

    @Override
    public String alterTableAddCheckConstraint(String tableName, String checkConstraintName, String checkConstraint) {
        if (USE_CHECK_CONSTRAINT) {
            return super.alterTableAddCheckConstraint(tableName, checkConstraintName, checkConstraint);
        }
        return null;
    }

    @Override
    public String alterTableDropConstraint(String tableName, String constraintName) {
        if (USE_CHECK_CONSTRAINT) {
            StringBuilder sb = new StringBuilder();
            sb.append("/*!80016 alter table ").append(tableName);
            sb.append(" drop check ").append(constraintName).append(" */;\n");
            sb.append("/*M!100201 ");
            sb.append(super.alterTableDropConstraint(tableName, constraintName));
            sb.append(" */");
            return sb.toString();
        }
        return null;
    }

    @Override
    public void alterColumn(DdlWrite writer, AlterColumn alter) {
        String tableName = alter.getTableName();
        String columnName = alter.getColumnName();
        if (alter.getType() == null && alter.isNotnull() == null) {
            if (this.hasValue(alter.getDefaultValue())) {
                this.alterColumnDefault(writer, alter);
            }
        } else {
            String type = alter.getType() != null ? alter.getType() : alter.getCurrentType();
            type = this.convert(type);
            boolean notnull = alter.isNotnull() != null ? alter.isNotnull().booleanValue() : Boolean.TRUE.equals(alter.isCurrentNotnull());
            String defaultValue = alter.getDefaultValue() != null ? alter.getDefaultValue() : alter.getCurrentDefaultValue();
            DdlBuffer buffer = this.alterTable(writer, tableName).append("modify", columnName);
            buffer.append(type);
            if (notnull) {
                buffer.append(" not null");
            }
            if (this.hasValue(defaultValue) && !DdlHelp.isDropDefault(defaultValue)) {
                buffer.append(" default ").append(this.convertDefaultValue(defaultValue));
            }
        }
    }

    @Override
    protected void writeColumnDefinition(DdlBuffer buffer, Column column, DdlIdentity identity) {
        super.writeColumnDefinition(buffer, column, identity);
        String comment = column.getComment();
        if (!StringHelper.isNull((String)comment)) {
            if (comment.length() > 500) {
                comment = comment.substring(0, 500);
            }
            buffer.append(String.format(" comment '%s'", comment));
        }
    }

    @Override
    public void inlineTableComment(DdlBuffer apply, String tableComment) {
        if (tableComment.length() > 1000) {
            tableComment = tableComment.substring(0, 1000);
        }
        apply.append(" comment='").append(tableComment).append("'");
    }

    @Override
    public void addTableComment(DdlBuffer apply, String tableName, String tableComment) {
        if (DdlHelp.isDropComment(tableComment)) {
            tableComment = "";
        }
        apply.append(String.format("alter table %s comment = '%s'", this.quote(tableName), tableComment)).endOfStatement();
    }

    @Override
    public void addColumnComment(DdlBuffer apply, String table, String column, String comment) {
    }
}

