/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.model;

import io.ebean.annotation.Platform;
import io.ebean.config.DbConstraintNaming;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.api.PlatformMatch;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.dbmigration.Detect;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlHandler;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlOptions;
import io.ebeaninternal.dbmigration.ddlgeneration.DdlWrite;
import io.ebeaninternal.dbmigration.ddlgeneration.PlatformDdlBuilder;
import io.ebeaninternal.dbmigration.migration.ChangeSet;
import io.ebeaninternal.dbmigration.model.MConfiguration;
import io.ebeaninternal.dbmigration.model.MTable;
import io.ebeaninternal.dbmigration.model.ModelContainer;
import io.ebeaninternal.dbmigration.model.ModelDiff;
import io.ebeaninternal.dbmigration.model.build.ModelBuildBeanVisitor;
import io.ebeaninternal.dbmigration.model.build.ModelBuildContext;
import io.ebeaninternal.dbmigration.model.visitor.BeanVisitor;
import io.ebeaninternal.dbmigration.model.visitor.VisitAllUsing;
import io.ebeaninternal.extraddl.model.DdlScript;
import io.ebeaninternal.extraddl.model.ExtraDdl;
import io.ebeaninternal.extraddl.model.ExtraDdlXmlReader;
import java.io.IOException;
import java.util.List;

public class CurrentModel {
    private final SpiEbeanServer server;
    private final DatabasePlatform databasePlatform;
    private final DbConstraintNaming constraintNaming;
    private final boolean platformTypes;
    private final boolean jaxbPresent;
    private final String ddlHeader;
    private final DdlOptions ddlOptions = new DdlOptions();
    private ModelContainer model;
    private ChangeSet changeSet;
    private DdlWrite writer;

    public CurrentModel(SpiEbeanServer server) {
        this(server, server.config().getConstraintNaming(), true);
    }

    public CurrentModel(SpiEbeanServer server, DbConstraintNaming constraintNaming) {
        this(server, constraintNaming, false);
    }

    private CurrentModel(SpiEbeanServer server, DbConstraintNaming constraintNaming, boolean platformTypes) {
        this.server = server;
        this.databasePlatform = server.databasePlatform();
        this.constraintNaming = constraintNaming;
        this.platformTypes = platformTypes;
        this.ddlHeader = server.config().getDdlHeader();
        this.jaxbPresent = Detect.isJAXBPresent(server.config());
    }

    public DdlOptions getDdlOptions() {
        return this.ddlOptions;
    }

    public boolean isTablePartitioning() {
        return this.read().isTablePartitioning();
    }

    public List<MTable> getPartitionedTables() {
        return this.read().getPartitionedTables();
    }

    public ModelContainer read() {
        if (this.model == null) {
            this.model = new ModelContainer();
            ModelBuildContext context = new ModelBuildContext(this.model, this.databasePlatform, this.constraintNaming, this.platformTypes);
            ModelBuildBeanVisitor visitor = new ModelBuildBeanVisitor(context);
            VisitAllUsing visit = new VisitAllUsing((BeanVisitor)visitor, this.server);
            visit.visitAllBeans();
        }
        return this.model;
    }

    public void setChangeSet(ChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    public ChangeSet getChangeSet() {
        this.read();
        if (this.changeSet == null) {
            this.changeSet = this.asChangeSet();
        }
        return this.changeSet;
    }

    public String getCreateDdl() {
        this.createDdl();
        StringBuilder ddl = new StringBuilder(2000);
        if (this.ddlHeader != null && !this.ddlHeader.isEmpty()) {
            ddl.append(this.ddlHeader).append('\n');
        }
        if (this.jaxbPresent) {
            this.addExtraDdl(ddl, ExtraDdlXmlReader.readBuiltin(), "-- init script ");
        }
        try {
            this.writer.writeApply(ddl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ddl.toString();
    }

    private void addExtraDdl(StringBuilder ddl, ExtraDdl extraDdl, String prefix) {
        if (extraDdl != null) {
            List<DdlScript> ddlScript = extraDdl.getDdlScript();
            for (DdlScript script : ddlScript) {
                if (!script.isInit() || !PlatformMatch.matchPlatform((Platform)this.server.platform(), (String)script.getPlatforms())) continue;
                ddl.append(prefix).append(script.getName()).append('\n');
                ddl.append(script.getValue());
            }
        }
    }

    public String getDropAllDdl() {
        this.createDdl();
        StringBuilder ddl = new StringBuilder(2000);
        if (this.ddlHeader != null && !this.ddlHeader.isEmpty()) {
            ddl.append(this.ddlHeader).append('\n');
        }
        try {
            this.writer.writeDropAll(ddl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ddl.toString();
    }

    private void createDdl() {
        if (this.writer == null) {
            ChangeSet createChangeSet = this.getChangeSet();
            this.writer = new DdlWrite(new MConfiguration(), this.model, this.ddlOptions);
            DdlHandler handler = this.handler();
            handler.generateProlog(this.writer);
            handler.generate(this.writer, createChangeSet);
            handler.generateEpilog(this.writer);
        }
    }

    private DdlHandler handler() {
        return PlatformDdlBuilder.create(this.databasePlatform).createDdlHandler(this.server.config());
    }

    private ChangeSet asChangeSet() {
        ModelDiff diff = new ModelDiff();
        diff.compareTo(this.model);
        return diff.getApplyChangeSet();
    }
}

