/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.containers;

import io.ebean.test.containers.BaseDbBuilder;
import io.ebean.test.containers.BaseJdbcContainer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class SqlServerContainer
extends BaseJdbcContainer<SqlServerContainer> {
    @Override
    public SqlServerContainer start() {
        this.startOrThrow();
        return this;
    }

    public static Builder builder(String version) {
        return new Builder(version);
    }

    @Deprecated
    public static Builder newBuilder(String version) {
        return SqlServerContainer.builder(version);
    }

    private SqlServerContainer(Builder builder) {
        super(builder);
    }

    @Override
    void createDatabase() {
        this.createRoleAndDatabase(false);
    }

    @Override
    void dropCreateDatabase() {
        this.createRoleAndDatabase(true);
    }

    @Override
    boolean checkConnectivity(boolean useAdmin) {
        if (!this.isDefaultCollation() && !this.logsContain("The default collation was successfully changed", "Attempting to change default collation")) {
            return false;
        }
        return super.checkConnectivity(useAdmin);
    }

    private boolean isDefaultCollation() {
        if (this.dbConfig.getCollation() == null) {
            return false;
        }
        return "default".equals(this.dbConfig.getCollation()) || "SQL_Latin1_General_CP1_CI_AS".equals(this.dbConfig.getCollation());
    }

    private void createRoleAndDatabase(boolean withDrop) {
        IllegalStateException cause = null;
        for (int i = 0; i < 3; ++i) {
            try {
                this.createRoleAndDatabaseAttempt(withDrop);
                return;
            }
            catch (IllegalStateException e) {
                log.log(System.Logger.Level.WARNING, "Error during retry attempt " + (i + 1), (Throwable)e);
                cause = e;
                SqlServerContainer.backoff();
                continue;
            }
        }
        throw new IllegalStateException("Failed retry attempts. Last error was:", cause);
    }

    private static void backoff() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted backoff during retry", ex);
        }
    }

    private void createRoleAndDatabaseAttempt(boolean withDrop) {
        try (Connection connection = this.config.createAdminConnection();){
            if (withDrop) {
                this.dropDatabaseIfExists(connection);
            }
            this.createDatabase(connection);
            this.createLogin(connection);
            this.createUser();
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error when creating database and role", e);
        }
    }

    private void createUser() {
        try (Connection dbConnection = this.dbConfig.createAdminConnection(this.dbConfig.jdbcUrl());){
            this.createUser(dbConnection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void createLogin(Connection connection) {
        if (!this.loginExists(connection, this.dbConfig.getUsername())) {
            this.createLogin(connection, this.dbConfig.getUsername(), this.dbConfig.getPassword());
        }
    }

    private void createUser(Connection dbConnection) {
        if (!this.userExists(dbConnection, this.dbConfig.getUsername())) {
            this.createUser(dbConnection, this.dbConfig.getUsername(), this.dbConfig.getUsername());
            this.grantOwner(dbConnection, this.dbConfig.getUsername());
        }
    }

    private void createDatabase(Connection connection) {
        if (!this.databaseExists(connection, this.dbConfig.getDbName())) {
            this.createDatabase(connection, this.dbConfig.getDbName());
        }
    }

    private void dropDatabaseIfExists(Connection connection) {
        if (this.databaseExists(connection, this.dbConfig.getDbName())) {
            this.dropDatabase(connection, this.dbConfig.getDbName());
        }
    }

    private void dropDatabase(Connection connection, String dbName) {
        this.sqlRun(connection, "alter database " + dbName + " set offline with rollback immediate");
        this.sqlRun(connection, "alter database " + dbName + " set online");
        this.sqlRun(connection, "drop database " + dbName);
    }

    private void createDatabase(Connection connection, String dbName) {
        this.sqlRun(connection, "create database " + dbName);
    }

    private void createLogin(Connection connection, String login, String pass) {
        this.sqlRun(connection, "create login " + login + " with password = '" + pass + "'");
    }

    private void createUser(Connection dbConnection, String roleName, String login) {
        this.sqlRun(dbConnection, "create user " + roleName + " for login " + login);
    }

    private void grantOwner(Connection dbConnection, String roleName) {
        this.sqlRun(dbConnection, "exec sp_addrolemember 'db_owner', " + roleName);
    }

    private boolean userExists(Connection dbConnection, String userName) {
        return this.sqlHasRow(dbConnection, "select 1 from sys.database_principals where name = '" + userName + "'");
    }

    private boolean loginExists(Connection connection, String roleName) {
        return this.sqlHasRow(connection, "select 1 from master.dbo.syslogins where loginname = '" + roleName + "'");
    }

    private boolean databaseExists(Connection connection, String dbName) {
        Exception lastError = null;
        for (int i = 0; i < 3; ++i) {
            try {
                return this.databaseExistsAttempt(connection, dbName);
            }
            catch (Exception e) {
                log.log(System.Logger.Level.INFO, "Failed databaseExistsAttempt() {0} with {1}", i, e.getMessage());
                lastError = e;
                this.waitTime();
                continue;
            }
        }
        log.log(System.Logger.Level.WARNING, "Failed databaseExists() check with last error captured of ...", lastError);
        throw new IllegalStateException("Failed databaseExists check with", lastError);
    }

    private void waitTime() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted during databaseExists");
        }
    }

    private boolean databaseExistsAttempt(Connection connection, String dbName) {
        return this.sqlHasRow(connection, "select 1 from sys.databases where name='" + dbName + "'");
    }

    @Override
    protected ProcessBuilder runProcess() {
        List<String> args = this.dockerRun();
        args.add("-e");
        args.add("ACCEPT_EULA=Y");
        args.add("-e");
        args.add("SA_PASSWORD=" + this.dbConfig.getAdminPassword());
        if (!this.dbConfig.isDefaultCollation()) {
            if (this.dbConfig.isExplicitCollation()) {
                args.add("-e");
                args.add("MSSQL_COLLATION=" + this.dbConfig.getCollation());
            } else {
                args.add("-e");
                args.add("MSSQL_COLLATION=Latin1_General_100_BIN2");
            }
        }
        args.add(this.config.getImage());
        return this.createProcessBuilder(args);
    }

    public static class Builder
    extends BaseDbBuilder<SqlServerContainer, Builder> {
        private Builder(String version) {
            super("sqlserver", 1433, 1433, version);
            this.image = "mcr.microsoft.com/mssql/server:" + version;
            this.adminUsername = "sa";
            this.adminPassword = "SqlS3rv#r";
            this.password = "SqlS3rv#r";
        }

        @Override
        protected String buildJdbcUrl() {
            return "jdbc:sqlserver://" + this.getHost() + ":" + this.getPort() + ";databaseName=" + this.getDbName() + ";integratedSecurity=false;trustServerCertificate=true";
        }

        @Override
        protected String buildJdbcAdminUrl() {
            return "jdbc:sqlserver://" + this.getHost() + ":" + this.getPort() + ";integratedSecurity=false;trustServerCertificate=true";
        }

        @Override
        public SqlServerContainer build() {
            return new SqlServerContainer(this);
        }

        @Override
        public SqlServerContainer start() {
            return this.build().start();
        }
    }
}

