/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.test.config;

import io.avaje.applog.AppLog;
import io.avaje.config.Config;
import io.ebean.DatabaseBuilder;
import io.ebean.config.AutoConfigure;
import io.ebean.datasource.DataSourceBuilder;
import io.ebean.test.config.RunOnceMarker;
import io.ebean.test.config.platform.PlatformAutoConfig;
import io.ebean.test.config.provider.ProviderAutoConfig;
import io.ebean.test.containers.DockerHost;
import java.util.Properties;

public class AutoConfigureForTesting
implements AutoConfigure {
    private static final System.Logger log = AppLog.getLogger((String)"io.ebean.test");
    private final String environmentDb = System.getProperty("db");

    public void preConfigure(DatabaseBuilder builder) {
        DatabaseBuilder.Settings config = builder.settings();
        Properties properties = config.getProperties();
        if (properties != null) {
            DockerHost.host();
            Config.asConfiguration().evalModify(properties);
        }
        if (!config.isDefaultServer()) {
            log.log(System.Logger.Level.INFO, "skip automatic testing config on non-default server name:{0} register:{1}", config.getName(), config.isRegister());
            return;
        }
        if (this.isExtraServer(config, properties)) {
            this.setupExtraDataSourceIfNecessary(config);
            return;
        }
        String testPlatform = properties.getProperty("ebean.test.platform");
        log.log(System.Logger.Level.DEBUG, "automatic testing config - with ebean.test.platform:{0} name:{1} environmentDb:{2}", testPlatform, config.getName(), this.environmentDb);
        if (RunOnceMarker.isRun()) {
            this.setupPlatform(this.environmentDb, config);
        }
    }

    public void postConfigure(DatabaseBuilder builder) {
        DatabaseBuilder.Settings config = builder.settings();
        if (!config.isDefaultServer()) {
            return;
        }
        this.setupProviders(config);
    }

    private void makeV1Compatible(DataSourceBuilder.Settings ds) {
        if (ds == null) {
            return;
        }
        String url = ds.getUrl();
        if (url == null || !url.startsWith("jdbc:h2:")) {
            return;
        }
        url = url.replace(";MODE=LEGACY", "");
        url = url.replace(";NON_KEYWORDS=KEY,VALUE", "");
        url = url.replace(";NON_KEYWORDS=KEY", "");
        ds.url(url);
    }

    private boolean isExtraServer(DatabaseBuilder.Settings config, Properties properties) {
        String extraDb = properties.getProperty("ebean.test.extraDb.dbName", properties.getProperty("ebean.test.extraDb"));
        if (extraDb != null && extraDb.equals(config.getName())) {
            config.setDefaultServer(false);
            return true;
        }
        return false;
    }

    private void setupExtraDataSourceIfNecessary(DatabaseBuilder.Settings config) {
        DataSourceBuilder.Settings dataSourceConfig = config.getDataSourceConfig();
        if (dataSourceConfig == null || dataSourceConfig.settings().getUsername() == null) {
            new PlatformAutoConfig(this.environmentDb, config).configExtraDataSource();
        }
    }

    private void setupProviders(DatabaseBuilder.Settings config) {
        new ProviderAutoConfig(config).run();
    }

    private void setupPlatform(String db, DatabaseBuilder.Settings config) {
        new PlatformAutoConfig(db, config).run();
    }
}

