/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.querybean.generator;

import io.ebean.querybean.generator.Append;
import io.ebean.querybean.generator.ProcessingContext;
import io.ebean.querybean.generator.PropertyMeta;
import io.ebean.querybean.generator.PropertyType;
import io.ebean.querybean.generator.Util;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.JavaFileObject;

class SimpleQueryBeanWriter {
    private final Set<String> importTypes = new TreeSet<String>();
    private final List<PropertyMeta> properties = new ArrayList<PropertyMeta>();
    private final TypeElement element;
    private final ProcessingContext processingContext;
    private final String dbName;
    private final String beanFullName;
    private final boolean isEntity;
    private final boolean embeddable;
    private boolean writingAssocBean;
    private String destPackage;
    private String origDestPackage;
    private String shortName;
    private final String shortInnerName;
    private final String origShortName;
    private Append writer;

    SimpleQueryBeanWriter(TypeElement element, ProcessingContext processingContext) {
        this.element = element;
        this.processingContext = processingContext;
        this.beanFullName = element.getQualifiedName().toString();
        boolean nested = element.getNestingKind().isNested();
        this.destPackage = Util.packageOf(nested, this.beanFullName) + ".query";
        String sn = Util.shortName(nested, this.beanFullName);
        this.shortInnerName = Util.shortName(false, sn);
        this.origShortName = this.shortName = sn.replace('.', '$');
        this.isEntity = processingContext.isEntity(element);
        this.embeddable = processingContext.isEmbeddable(element);
        this.dbName = this.findDbName();
    }

    private String findDbName() {
        return this.processingContext.findDbName(this.element);
    }

    private boolean isEntity() {
        return this.isEntity;
    }

    private boolean isEmbeddable() {
        return this.embeddable;
    }

    private void gatherPropertyDetails() {
        this.importTypes.add("io.ebean.typequery.Generated");
        this.importTypes.add(this.beanFullName);
        this.importTypes.add("io.ebean.typequery.TQRootBean");
        this.importTypes.add("io.ebean.typequery.TypeQueryBean");
        this.importTypes.add("io.ebean.Database");
        this.importTypes.add("io.ebean.FetchGroup");
        this.importTypes.add("io.ebean.Query");
        this.importTypes.add("io.ebean.Transaction");
        if (this.dbName != null) {
            this.importTypes.add("io.ebean.DB");
        }
        this.addClassProperties();
    }

    private void addClassProperties() {
        for (VariableElement field : this.processingContext.allFields(this.element)) {
            PropertyType type = this.processingContext.getPropertyType(field);
            if (type == null) continue;
            type.addImports(this.importTypes);
            this.properties.add(new PropertyMeta(field.getSimpleName().toString(), type));
        }
    }

    void writeRootBean() throws IOException {
        this.gatherPropertyDetails();
        if (this.isEmbeddable()) {
            this.processingContext.addEntity(this.beanFullName, this.dbName);
        } else if (this.isEntity()) {
            this.processingContext.addEntity(this.beanFullName, this.dbName);
            this.writer = new Append(this.createFileWriter());
            this.writePackage();
            this.writeImports();
            this.writeClass();
            this.writeAlias();
            this.writeFields();
            this.writeConstructors();
            this.writeStaticAliasClass();
            this.writeClassEnd();
            this.writer.close();
        }
    }

    void writeAssocBean() throws IOException {
        this.writingAssocBean = true;
        this.origDestPackage = this.destPackage;
        this.destPackage = this.destPackage + ".assoc";
        this.shortName = "Assoc" + this.shortName;
        this.prepareAssocBeanImports();
        this.writer = new Append(this.createFileWriter());
        this.writePackage();
        this.writeImports();
        this.writeClass();
        this.writeFields();
        this.writeConstructors();
        this.writeClassEnd();
        this.writer.close();
    }

    private void prepareAssocBeanImports() {
        this.importTypes.remove("io.ebean.DB");
        this.importTypes.remove("io.ebean.typequery.TQRootBean");
        this.importTypes.remove("io.ebean.Database");
        this.importTypes.remove("io.ebean.FetchGroup");
        this.importTypes.remove("io.ebean.Query");
        this.importTypes.add("io.ebean.typequery.TQAssocBean");
        if (this.isEntity()) {
            this.importTypes.add("io.ebean.typequery.TQProperty");
            this.importTypes.add(this.origDestPackage + ".Q" + this.origShortName);
        }
        Iterator<String> importsIterator = this.importTypes.iterator();
        String checkImportStart = this.destPackage + ".QAssoc";
        while (importsIterator.hasNext()) {
            String importType = importsIterator.next();
            if (!importType.startsWith(checkImportStart)) continue;
            importsIterator.remove();
        }
    }

    private void writeConstructors() {
        if (this.writingAssocBean) {
            this.writeAssocBeanFetch();
            this.writeAssocBeanConstructor();
        } else {
            this.writeRootBeanConstructor();
        }
    }

    private void writeRootBeanConstructor() {
        this.writer.eol();
        this.writer.append("  /**").eol();
        this.writer.append("   * Return a query bean used to build a FetchGroup.").eol();
        this.writer.append("   * <p>").eol();
        this.writer.append("   * FetchGroups are immutable and threadsafe and can be used by many").eol();
        this.writer.append("   * concurrent queries. We typically stored FetchGroup as a static final field.").eol();
        this.writer.append("   * <p>").eol();
        this.writer.append("   * Example creating and using a FetchGroup.").eol();
        this.writer.append("   * <pre>{@code").eol();
        this.writer.append("   * ").eol();
        this.writer.append("   * static final FetchGroup<Customer> fetchGroup = ").eol();
        this.writer.append("   *   QCustomer.forFetchGroup()").eol();
        this.writer.append("   *     .shippingAddress.fetch()").eol();
        this.writer.append("   *     .contacts.fetch()").eol();
        this.writer.append("   *     .buildFetchGroup();").eol();
        this.writer.append("   * ").eol();
        this.writer.append("   * List<Customer> customers = new QCustomer()").eol();
        this.writer.append("   *   .select(fetchGroup)").eol();
        this.writer.append("   *   .findList();").eol();
        this.writer.append("   * ").eol();
        this.writer.append("   * }</pre>").eol();
        this.writer.append("   */").eol();
        this.writer.append("  public static Q%s forFetchGroup() {", this.shortName).eol();
        this.writer.append("    return new Q%s(FetchGroup.queryFor(%s.class));", this.shortName, this.shortName).eol();
        this.writer.append("  }").eol();
        this.writer.eol();
        String name = this.dbName == null ? "default" : this.dbName;
        this.writer.append("  /**").eol();
        this.writer.append("   * Construct using the %s Database.", name).eol();
        this.writer.append("   */").eol();
        this.writer.append("  public Q%s() {", this.shortName).eol();
        if (this.dbName == null) {
            this.writer.append("    super(%s.class);", this.shortName).eol();
        } else {
            this.writer.append("    super(%s.class, DB.byName(\"%s\"));", this.shortName, this.dbName).eol();
        }
        this.writer.append("  }").eol();
        this.writer.eol();
        this.writer.append("  /**").eol();
        this.writer.append("   * Construct with a given transaction.", name).eol();
        this.writer.append("   */").eol();
        this.writer.append("  public Q%s(Transaction transaction) {", this.shortName).eol();
        if (this.dbName == null) {
            this.writer.append("    super(%s.class, transaction);", this.shortName).eol();
        } else {
            this.writer.append("    super(%s.class, DB.byName(\"%s\"), transaction);", this.shortName, this.dbName).eol();
        }
        this.writer.append("  }").eol();
        this.writer.eol();
        this.writer.append("  /**").eol();
        this.writer.append("   * Construct with a given Database.").eol();
        this.writer.append("   */").eol();
        this.writer.append("  public Q%s(Database database) {", this.shortName).eol();
        this.writer.append("    super(%s.class, database);", this.shortName).eol();
        this.writer.append("  }").eol();
        this.writer.eol();
        this.writer.eol();
        this.writer.append("  /**").eol();
        this.writer.append("   * Construct for Alias.").eol();
        this.writer.append("   */").eol();
        this.writer.append("  private Q%s(boolean dummy) {", this.shortName).eol();
        this.writer.append("    super(dummy);").eol();
        this.writer.append("  }").eol();
        this.writer.eol();
        this.writer.append("  /**").eol();
        this.writer.append("   * Private constructor for FetchGroup building.").eol();
        this.writer.append("   */").eol();
        this.writer.append("  private Q%s(Query<%s> fetchGroupQuery) {", this.shortName, this.shortName).eol();
        this.writer.append("    super(fetchGroupQuery);").eol();
        this.writer.append("  }").eol();
    }

    private void writeAssocBeanFetch() {
        if (this.isEntity()) {
            this.writeAssocBeanFetch("", "Eagerly fetch this association loading the specified properties.");
            this.writeAssocBeanFetch("Query", "Eagerly fetch this association using a 'query join' loading the specified properties.");
            this.writeAssocBeanFetch("Cache", "Eagerly fetch this association using L2 cache.");
            this.writeAssocBeanFetch("Lazy", "Use lazy loading for this association loading the specified properties.");
        }
    }

    private void writeAssocBeanFetch(String fetchType, String comment) {
        this.writer.append("  /**").eol();
        this.writer.append("   * ").append(comment).eol();
        this.writer.append("   */").eol();
        this.writer.append("  @SafeVarargs @SuppressWarnings(\"varargs\")").eol();
        this.writer.append("  public final R fetch%s(TQProperty<Q%s>... properties) {", fetchType, this.origShortName).eol();
        this.writer.append("    return fetch%sProperties(properties);", fetchType).eol();
        this.writer.append("  }").eol();
        this.writer.eol();
    }

    private void writeAssocBeanConstructor() {
        this.writer.append("  public Q%s(String name, R root) {", this.shortName).eol();
        this.writer.append("    super(name, root);").eol();
        this.writer.append("  }").eol().eol();
        this.writer.append("  public Q%s(String name, R root, String prefix) {", this.shortName).eol();
        this.writer.append("    super(name, root, prefix);").eol();
        this.writer.append("  }").eol();
    }

    private void writeFields() {
        for (PropertyMeta property : this.properties) {
            property.writeFieldDefn(this.writer, this.shortName, this.writingAssocBean);
            this.writer.eol();
        }
        this.writer.eol();
    }

    private void writeClass() {
        if (this.writingAssocBean) {
            this.writer.append("/**").eol();
            this.writer.append(" * Association query bean for %s.", this.shortName).eol();
            this.writer.append(" * ").eol();
            this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").eol();
            this.writer.append(" */").eol();
            this.writer.append("@Generated(\"io.ebean.querybean.generator\")").eol();
            this.writer.append("@TypeQueryBean(\"v1\")").eol();
            this.writer.append("public class Q%s<R> extends TQAssocBean<%s,R> {", this.shortName, this.shortInnerName).eol();
        } else {
            this.writer.append("/**").eol();
            this.writer.append(" * Query bean for %s.", this.shortName).eol();
            this.writer.append(" * ").eol();
            this.writer.append(" * THIS IS A GENERATED OBJECT, DO NOT MODIFY THIS CLASS.").eol();
            this.writer.append(" */").eol();
            this.writer.append("@Generated(\"io.ebean.querybean.generator\")").eol();
            this.writer.append("@TypeQueryBean(\"v1\")").eol();
            this.writer.append("public class Q%s extends TQRootBean<%1$s,Q%1$s> {", this.shortName).eol();
        }
        this.writer.eol();
    }

    private void writeAlias() {
        if (!this.writingAssocBean) {
            this.writer.append("  private static final Q%s _alias = new Q%1$s(true);", this.shortName).eol().eol();
            this.writer.append("  /**").eol();
            this.writer.append("   * Return the shared 'Alias' instance used to provide properties to ").eol();
            this.writer.append("   * <code>select()</code> and <code>fetch()</code> ").eol();
            this.writer.append("   */").eol();
            this.writer.append("  public static Q%s alias() {", this.shortName).eol();
            this.writer.append("    return _alias;").eol();
            this.writer.append("  }").eol();
            this.writer.eol();
        }
    }

    private void writeStaticAliasClass() {
        this.writer.eol();
        this.writer.append("  /**").eol();
        this.writer.append("   * Provides static properties to use in <em> select() and fetch() </em>").eol();
        this.writer.append("   * clauses of a query. Typically referenced via static imports. ").eol();
        this.writer.append("   */").eol();
        this.writer.append("  public static class Alias {").eol();
        for (PropertyMeta property : this.properties) {
            property.writeFieldAliasDefn(this.writer, this.shortName);
            this.writer.eol();
        }
        this.writer.append("  }").eol();
    }

    private void writeClassEnd() {
        this.writer.append("}").eol();
    }

    private void writeImports() {
        for (String importType : this.importTypes) {
            this.writer.append("import %s;", importType).eol();
        }
        this.writer.eol();
    }

    private void writePackage() {
        this.writer.append("package %s;", this.destPackage).eol().eol();
    }

    private Writer createFileWriter() throws IOException {
        JavaFileObject jfo = this.processingContext.createWriter(this.destPackage + ".Q" + this.shortName, this.element);
        return jfo.openWriter();
    }
}

