/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.api.ota;

import com.crashlytics.reloc.com.google.common.base.Charsets;
import com.crashlytics.reloc.org.apache.commons.io.IOUtils;
import com.crashlytics.reloc.org.apache.http.HttpResponse;
import com.crashlytics.reloc.org.json.simple.JSONObject;
import com.crashlytics.reloc.org.json.simple.JSONValue;
import java.io.IOException;
import java.io.InputStreamReader;

public class DadsApiException
extends IOException {
    private static final String DADS_JSON_ERROR_KEY = "error";
    private static final String DADS_JSON_ERROR_MESSAGE_KEY = "message";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T throwDadsApiExceptionOrReturn(T fallback, HttpResponse response) throws IOException {
        InputStreamReader reader = null;
        try {
            String message;
            JSONObject errorJson;
            reader = new InputStreamReader(response.getEntity().getContent(), Charsets.UTF_8);
            JSONObject jsonObject = (JSONObject)JSONValue.parse(reader);
            if (jsonObject != null && (errorJson = (JSONObject)jsonObject.get(DADS_JSON_ERROR_KEY)) != null && (message = (String)errorJson.get(DADS_JSON_ERROR_MESSAGE_KEY)) != null) {
                throw new DadsApiException(message);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        return fallback;
    }

    public DadsApiException(String message) {
        super(message);
    }
}

