/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ram;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileType;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractFileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ram.RamFileData;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ram.RamFileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.ram.RamFileProvider;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RamFileSystem
extends AbstractFileSystem
implements Serializable {
    private Map cache = Collections.synchronizedMap(new HashMap());

    protected RamFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        RamFileData rootData = new RamFileData(rootName);
        rootData.setType(FileType.FOLDER);
        rootData.setLastModified(System.currentTimeMillis());
        this.cache.put(rootName, rootData);
    }

    protected FileObject createFile(FileName name) throws Exception {
        RamFileObject file = new RamFileObject(name, this);
        return file;
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(RamFileProvider.capabilities);
    }

    String[] listChildren(FileName name) {
        RamFileData data = (RamFileData)this.cache.get(name);
        Collection children = data.getChildren();
        String[] names = new String[children.size()];
        int pos = 0;
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            RamFileData childData = (RamFileData)iter.next();
            names[pos] = childData.getName().getBaseName();
            ++pos;
        }
        return names;
    }

    void delete(RamFileObject file) throws FileSystemException {
        if (file.getParent() == null) {
            throw new FileSystemException("unable to delete root");
        }
        this.cache.remove(file.getName());
        RamFileObject parent = (RamFileObject)this.resolveFile(file.getParent().getName());
        parent.getData().removeChild(file.getData());
        parent.close();
        file.getData().clear();
        file.close();
    }

    void save(RamFileObject file) throws FileSystemException {
        RamFileData parentData;
        if (file.getData().getName() == null) {
            throw new FileSystemException(new IllegalStateException("The data has no name. " + file));
        }
        if (file.getName().getDepth() > 0 && !(parentData = (RamFileData)this.cache.get(file.getParent().getName())).hasChildren(file.getData())) {
            RamFileObject parent = (RamFileObject)file.getParent();
            parent.getData().addChild(file.getData());
            parent.close();
        }
        this.cache.put(file.getName(), file.getData());
        file.getData().updateLastModified();
        file.close();
    }

    void rename(RamFileObject from, RamFileObject to) throws FileSystemException {
        if (!this.cache.containsKey(from.getName())) {
            throw new FileSystemException("File does not exist: " + from.getName());
        }
        to.getData().setBuffer(from.getData().getBuffer());
        to.getData().setLastModified(from.getData().getLastModified());
        to.getData().setType(from.getData().getType());
        this.save(to);
        this.delete(from);
    }

    public void attach(RamFileObject fo) {
        if (fo.getName() == null) {
            throw new IllegalArgumentException("Null argument");
        }
        RamFileData data = (RamFileData)this.cache.get(fo.getName());
        if (data == null) {
            data = new RamFileData(fo.getName());
        }
        fo.setData(data);
    }

    public void importTree(File file) throws FileSystemException {
        FileObject fileFo = this.getFileSystemManager().toFileObject(file);
        this.toRamFileObject(fileFo, fileFo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toRamFileObject(FileObject fo, FileObject root) throws FileSystemException {
        block14: {
            RamFileObject memFo = (RamFileObject)this.resolveFile(fo.getName().getPath().substring(root.getName().getPath().length()));
            if (fo.getType().hasChildren()) {
                memFo.createFolder();
                FileObject[] fos = fo.getChildren();
                for (int i = 0; i < fos.length; ++i) {
                    FileObject child = fos[i];
                    this.toRamFileObject(child, root);
                }
            } else {
                if (fo.getType().equals(FileType.FILE)) {
                    try {
                        InputStream is = fo.getContent().getInputStream();
                        try {
                            int i;
                            BufferedOutputStream os = new BufferedOutputStream(memFo.getOutputStream(), 512);
                            while ((i = is.read()) != -1) {
                                ((OutputStream)os).write(i);
                            }
                            ((OutputStream)os).flush();
                            ((OutputStream)os).close();
                            break block14;
                        }
                        finally {
                            try {
                                is.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                    catch (IOException e) {
                        throw new FileSystemException(e.getClass().getName() + " " + e.getMessage());
                    }
                }
                throw new FileSystemException("File is not a folder nor a file " + memFo);
            }
        }
    }

    int size() {
        int size = 0;
        Iterator iter = this.cache.values().iterator();
        while (iter.hasNext()) {
            RamFileData data = (RamFileData)iter.next();
            size += data.size();
        }
        return size;
    }

    public void close() {
        this.cache = null;
        super.close();
    }
}

