/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.tasks;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileContent;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.tasks.VfsTask;
import com.crashlytics.reloc.org.apache.tools.ant.BuildException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;

public class ShowFileTask
extends VfsTask {
    private String url;
    private boolean showContent;
    private boolean recursive;
    private static final String INDENT = "  ";

    public void setFile(String url) {
        this.url = url;
    }

    public void setShowContent(boolean showContent) {
        this.showContent = showContent;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void execute() throws BuildException {
        try {
            FileObject file = this.resolveFile(this.url);
            this.log("Details of " + file.getName().getURI());
            this.showFile(file, INDENT);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void showFile(FileObject file, String prefix) throws Exception {
        StringBuffer msg = new StringBuffer(prefix);
        msg.append(file.getName().getBaseName());
        if (file.exists()) {
            msg.append(" (");
            msg.append(file.getType().getName());
            msg.append(")");
        } else {
            msg.append(" (unknown)");
        }
        this.log(msg.toString());
        if (file.exists()) {
            String newPrefix = prefix + INDENT;
            if (file.getType().hasContent()) {
                FileContent content = file.getContent();
                this.log(newPrefix + "Content-Length: " + content.getSize());
                this.log(newPrefix + "Last-Modified" + new Date(content.getLastModifiedTime()));
                if (this.showContent) {
                    this.log(newPrefix + "Content:");
                    this.logContent(file, newPrefix);
                }
            }
            if (file.getType().hasChildren()) {
                FileObject[] children = file.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    FileObject child = children[i];
                    if (this.recursive) {
                        this.showFile(child, newPrefix);
                        continue;
                    }
                    this.log(newPrefix + child.getName().getBaseName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logContent(FileObject file, String prefix) throws Exception {
        InputStream instr = file.getContent().getInputStream();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(instr));
            while ((line = reader.readLine()) != null) {
                this.log(prefix + line);
            }
        }
        finally {
            instr.close();
        }
    }
}

