/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MonitorInputStream
extends BufferedInputStream {
    private boolean finished;
    private long count = 0L;

    public MonitorInputStream(InputStream in) {
        super(in);
    }

    public int read() throws IOException {
        if (this.finished) {
            return -1;
        }
        int ch = super.read();
        if (ch != -1) {
            ++this.count;
            return ch;
        }
        this.close();
        return -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.finished) {
            return -1;
        }
        int nread = super.read(buffer, offset, length);
        if (nread != -1) {
            this.count += (long)nread;
            return nread;
        }
        this.close();
        return -1;
    }

    public void close() throws IOException {
        if (this.finished) {
            return;
        }
        IOException exc = null;
        try {
            super.close();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        try {
            this.onClose();
        }
        catch (IOException ioe) {
            exc = ioe;
        }
        this.finished = true;
        if (exc != null) {
            throw exc;
        }
    }

    protected void onClose() throws IOException {
    }

    public long getCount() {
        return this.count;
    }
}

