/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.avd;

import com.crashlytics.reloc.com.android.io.FileWrapper;
import com.crashlytics.reloc.com.android.io.IAbstractFile;
import com.crashlytics.reloc.com.android.prefs.AndroidLocation;
import com.crashlytics.reloc.com.android.sdklib.IAndroidTarget;
import com.crashlytics.reloc.com.android.sdklib.ISdkLog;
import com.crashlytics.reloc.com.android.sdklib.ISystemImage;
import com.crashlytics.reloc.com.android.sdklib.SdkConstants;
import com.crashlytics.reloc.com.android.sdklib.SdkManager;
import com.crashlytics.reloc.com.android.sdklib.internal.avd.AvdInfo;
import com.crashlytics.reloc.com.android.sdklib.internal.project.ProjectProperties;
import com.crashlytics.reloc.com.android.sdklib.util.GrabProcessOutput;
import com.crashlytics.reloc.com.android.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvdManager {
    public static final String AVD_FOLDER_EXTENSION = ".avd";
    public static final String AVD_INFO_PATH = "path";
    public static final String AVD_INFO_TARGET = "target";
    public static final String AVD_INI_ABI_TYPE = "abi.type";
    public static final String AVD_INI_CPU_ARCH = "hw.cpu.arch";
    public static final String AVD_INI_CPU_MODEL = "hw.cpu.model";
    public static final String AVD_INI_SKIN_PATH = "skin.path";
    public static final String AVD_INI_SKIN_NAME = "skin.name";
    public static final String AVD_INI_SDCARD_PATH = "sdcard.path";
    public static final String AVD_INI_SDCARD_SIZE = "sdcard.size";
    public static final String AVD_INI_IMAGES_1 = "image.sysdir.1";
    public static final String AVD_INI_IMAGES_2 = "image.sysdir.2";
    public static final String AVD_INI_SNAPSHOT_PRESENT = "snapshot.present";
    public static final Pattern NUMERIC_SKIN_SIZE = Pattern.compile("([0-9]{2,})x([0-9]{2,})");
    private static final String USERDATA_IMG = "userdata.img";
    static final String CONFIG_INI = "config.ini";
    private static final String SDCARD_IMG = "sdcard.img";
    private static final String SNAPSHOTS_IMG = "snapshots.img";
    static final String INI_EXTENSION = ".ini";
    private static final Pattern INI_NAME_PATTERN = Pattern.compile("(.+)\\.ini$", 2);
    private static final Pattern IMAGE_NAME_PATTERN = Pattern.compile("(.+)\\.img$", 2);
    private static final Pattern SDCARD_SIZE_PATTERN = Pattern.compile("(\\d+)([KMG])");
    public static final long SDCARD_MIN_BYTE_SIZE = 0x900000L;
    public static final long SDCARD_MAX_BYTE_SIZE = 0xFFC0000000L;
    public static final int SDCARD_SIZE_NOT_IN_RANGE = 0;
    public static final int SDCARD_SIZE_INVALID = -1;
    public static final int SDCARD_NOT_SIZE_PATTERN = -2;
    public static final Pattern RE_AVD_NAME = Pattern.compile("[a-zA-Z0-9._-]+");
    public static final String CHARS_AVD_NAME = "a-z A-Z 0-9 . _ -";
    public static final String HARDWARE_INI = "hardware.ini";
    private final ArrayList<AvdInfo> mAllAvdList = new ArrayList();
    private AvdInfo[] mValidAvdList;
    private AvdInfo[] mBrokenAvdList;
    private final SdkManager mSdkManager;

    public AvdManager(SdkManager sdkManager, ISdkLog iSdkLog) throws AndroidLocation.AndroidLocationException {
        this.mSdkManager = sdkManager;
        this.buildAvdList(this.mAllAvdList, iSdkLog);
    }

    public String getBaseAvdFolder() throws AndroidLocation.AndroidLocationException {
        assert (AndroidLocation.getFolder().endsWith(File.separator));
        return AndroidLocation.getFolder() + "avd";
    }

    public SdkManager getSdkManager() {
        return this.mSdkManager;
    }

    public static long parseSdcardSize(String string, String[] stringArray) {
        Matcher matcher;
        if (stringArray != null) {
            assert (stringArray.length == 2);
            stringArray[0] = null;
            stringArray[1] = null;
        }
        if ((matcher = SDCARD_SIZE_PATTERN.matcher(string)).matches()) {
            if (stringArray != null) {
                assert (stringArray.length == 2);
                stringArray[0] = matcher.group(1);
                stringArray[1] = matcher.group(2);
            }
            try {
                long l = Long.parseLong(matcher.group(1));
                String string2 = matcher.group(2);
                if ("K".equals(string2)) {
                    l <<= 10;
                } else if ("M".equals(string2)) {
                    l <<= 20;
                } else if ("G".equals(string2)) {
                    l <<= 30;
                }
                if (l < 0x900000L || l > 0xFFC0000000L) {
                    return 0L;
                }
                return l;
            }
            catch (NumberFormatException numberFormatException) {
                return -1L;
            }
        }
        return -2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getAllAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            return this.mAllAvdList.toArray(new AvdInfo[this.mAllAvdList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getValidAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mValidAvdList == null) {
                ArrayList<AvdInfo> arrayList2 = new ArrayList<AvdInfo>();
                for (AvdInfo avdInfo : this.mAllAvdList) {
                    if (avdInfo.getStatus() != AvdInfo.AvdStatus.OK) continue;
                    arrayList2.add(avdInfo);
                }
                this.mValidAvdList = arrayList2.toArray(new AvdInfo[arrayList2.size()]);
            }
            return this.mValidAvdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getBrokenAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mBrokenAvdList == null) {
                ArrayList<AvdInfo> arrayList2 = new ArrayList<AvdInfo>();
                for (AvdInfo avdInfo : this.mAllAvdList) {
                    if (avdInfo.getStatus() == AvdInfo.AvdStatus.OK) continue;
                    arrayList2.add(avdInfo);
                }
                this.mBrokenAvdList = arrayList2.toArray(new AvdInfo[arrayList2.size()]);
            }
            return this.mBrokenAvdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo getAvd(String string, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = SdkConstants.currentPlatform() == 2;
        if (bl) {
            for (AvdInfo avdInfo : this.getValidAvds()) {
                String string2 = avdInfo.getName();
                if (!string2.equals(string) && (!bl2 || !string2.equalsIgnoreCase(string))) continue;
                return avdInfo;
            }
        } else {
            ArrayList<AvdInfo> arrayList = this.mAllAvdList;
            synchronized (arrayList) {
                for (AvdInfo avdInfo : this.mAllAvdList) {
                    String string3 = avdInfo.getName();
                    if (!string3.equals(string) && (!bl2 || !string3.equalsIgnoreCase(string))) continue;
                    return avdInfo;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<AvdConflict, String> isAvdNameConflicting(String string) {
        boolean bl = SdkConstants.currentPlatform() == 2;
        Serializable serializable = this.mAllAvdList;
        synchronized (serializable) {
            for (AvdInfo avdInfo : this.mAllAvdList) {
                String string2 = avdInfo.getName();
                if (!string2.equals(string) && (!bl || !string2.equalsIgnoreCase(string))) continue;
                if (avdInfo.getStatus() == AvdInfo.AvdStatus.OK) {
                    return Pair.of(AvdConflict.CONFLICT_EXISTING_AVD, string2);
                }
                return Pair.of(AvdConflict.CONFLICT_INVALID_AVD, string2);
            }
        }
        try {
            serializable = AvdInfo.getDefaultIniFile(this, string);
            if (((File)serializable).exists()) {
                return Pair.of(AvdConflict.CONFLICT_EXISTING_PATH, ((File)serializable).getPath());
            }
            serializable = AvdInfo.getDefaultAvdFolder(this, string);
            if (((File)serializable).exists()) {
                return Pair.of(AvdConflict.CONFLICT_EXISTING_PATH, ((File)serializable).getPath());
            }
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            // empty catch block
        }
        return Pair.of(AvdConflict.NO_CONFLICT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAvds(ISdkLog iSdkLog) throws AndroidLocation.AndroidLocationException {
        ArrayList<AvdInfo> arrayList = new ArrayList<AvdInfo>();
        this.buildAvdList(arrayList, iSdkLog);
        ArrayList<AvdInfo> arrayList2 = this.mAllAvdList;
        synchronized (arrayList2) {
            this.mAllAvdList.clear();
            this.mAllAvdList.addAll(arrayList);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
    }

    /*
     * Exception decompiling
     */
    public AvdInfo createAvd(File var1_1, String var2_2, IAndroidTarget var3_3, String var4_4, String var5_5, String var6_6, Map<String, String> var7_7, boolean var8_8, boolean var9_9, boolean var10_10, ISdkLog var11_11) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void copyImageFile(File file, File file2) throws FileNotFoundException, IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[4096];
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
        fileInputStream.close();
    }

    private String getImageRelativePath(IAndroidTarget iAndroidTarget, String string) throws InvalidTargetPathException {
        String[] stringArray;
        String string2;
        ISystemImage iSystemImage = iAndroidTarget.getSystemImage(string);
        if (iSystemImage == null) {
            return null;
        }
        File file = iSystemImage.getLocation();
        String string3 = file.getAbsolutePath();
        if (!string3.startsWith(string2 = this.mSdkManager.getLocation())) {
            assert (false);
            throw new InvalidTargetPathException("Target location is not inside the SDK.");
        }
        if (file.isDirectory() && (stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return IMAGE_NAME_PATTERN.matcher(string).matches();
            }
        })).length > 0) {
            if ((string3 = string3.substring(string2.length())).charAt(0) == File.separatorChar) {
                string3 = string3.substring(1);
            }
            if (!string3.endsWith(File.separator)) {
                string3 = string3 + File.separator;
            }
            return string3;
        }
        return null;
    }

    public String getSkinRelativePath(String string, IAndroidTarget iAndroidTarget, ISdkLog iSdkLog) {
        String string2;
        if (iSdkLog == null) {
            throw new IllegalArgumentException("log cannot be null");
        }
        File file = this.getSkinPath(string, iAndroidTarget);
        if (!file.exists()) {
            iSdkLog.error(null, "Skin '%1$s' does not exist.", string);
            return null;
        }
        String string3 = file.getAbsolutePath();
        if (!string3.startsWith(string2 = this.mSdkManager.getLocation())) {
            iSdkLog.error(null, "Target location is not inside the SDK.", new Object[0]);
            assert (false);
            return null;
        }
        if ((string3 = string3.substring(string2.length())).charAt(0) == File.separatorChar) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    public File getSkinPath(String string, IAndroidTarget iAndroidTarget) {
        String string2 = iAndroidTarget.getPath(5);
        File file = new File(string2, string);
        if (!file.exists() && !iAndroidTarget.isPlatform()) {
            iAndroidTarget = iAndroidTarget.getParent();
            string2 = iAndroidTarget.getPath(5);
            file = new File(string2, string);
        }
        return file;
    }

    private File createAvdIniFile(String string, File file, IAndroidTarget iAndroidTarget, boolean bl) throws AndroidLocation.AndroidLocationException, IOException {
        File file2 = AvdInfo.getDefaultIniFile(this, string);
        if (bl) {
            if (file2.isFile()) {
                file2.delete();
            } else if (file2.isDirectory()) {
                this.deleteContentOf(file2);
                file2.delete();
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(AVD_INFO_PATH, file.getAbsolutePath());
        hashMap.put(AVD_INFO_TARGET, iAndroidTarget.hashString());
        AvdManager.writeIniFile(file2, hashMap);
        return file2;
    }

    private File createAvdIniFile(AvdInfo avdInfo) throws AndroidLocation.AndroidLocationException, IOException {
        return this.createAvdIniFile(avdInfo.getName(), new File(avdInfo.getDataFolderPath()), avdInfo.getTarget(), false);
    }

    public boolean deleteAvd(AvdInfo avdInfo, ISdkLog iSdkLog) {
        try {
            String string;
            boolean bl = false;
            File file = avdInfo.getIniFile();
            if (file != null && file.exists()) {
                iSdkLog.printf("Deleting file %1$s\n", file.getCanonicalPath());
                if (!file.delete()) {
                    iSdkLog.error(null, "Failed to delete %1$s\n", file.getCanonicalPath());
                    bl = true;
                }
            }
            if ((string = avdInfo.getDataFolderPath()) != null && (file = new File(string)).exists()) {
                iSdkLog.printf("Deleting folder %1$s\n", file.getCanonicalPath());
                if (!this.deleteContentOf(file) || !file.delete()) {
                    iSdkLog.error(null, "Failed to delete %1$s\n", file.getCanonicalPath());
                    bl = true;
                }
            }
            this.removeAvd(avdInfo);
            if (!bl) {
                iSdkLog.printf("\nAVD '%1$s' deleted.\n", avdInfo.getName());
                return true;
            }
            iSdkLog.printf("\nAVD '%1$s' deleted with errors. See errors above.\n", avdInfo.getName());
        }
        catch (IOException iOException) {
            iSdkLog.error(iOException, null, new Object[0]);
        }
        catch (SecurityException securityException) {
            iSdkLog.error(securityException, null, new Object[0]);
        }
        return false;
    }

    public boolean moveAvd(AvdInfo avdInfo, String string, String string2, ISdkLog iSdkLog) {
        try {
            Comparable<File> comparable;
            File file;
            if (string2 != null) {
                file = new File(avdInfo.getDataFolderPath());
                iSdkLog.warning("Moving '%1$s' to '%2$s'.", avdInfo.getDataFolderPath(), string2);
                if (!file.renameTo(new File(string2))) {
                    iSdkLog.error(null, "Failed to move '%1$s' to '%2$s'.", avdInfo.getDataFolderPath(), string2);
                    return false;
                }
                comparable = new AvdInfo(avdInfo.getName(), avdInfo.getIniFile(), string2, avdInfo.getTargetHash(), avdInfo.getTarget(), avdInfo.getAbiType(), avdInfo.getProperties());
                this.replaceAvd(avdInfo, (AvdInfo)comparable);
                this.createAvdIniFile((AvdInfo)comparable);
            }
            if (string != null) {
                file = avdInfo.getIniFile();
                comparable = AvdInfo.getDefaultIniFile(this, string);
                iSdkLog.warning("Moving '%1$s' to '%2$s'.", file.getPath(), comparable.getPath());
                if (!file.renameTo((File)comparable)) {
                    iSdkLog.error(null, "Failed to move '%1$s' to '%2$s'.", file.getPath(), comparable.getPath());
                    return false;
                }
                AvdInfo avdInfo2 = new AvdInfo(string, avdInfo.getIniFile(), avdInfo.getDataFolderPath(), avdInfo.getTargetHash(), avdInfo.getTarget(), avdInfo.getAbiType(), avdInfo.getProperties());
                this.replaceAvd(avdInfo, avdInfo2);
            }
            iSdkLog.printf("AVD '%1$s' moved.\n", avdInfo.getName());
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            iSdkLog.error(androidLocationException, null, new Object[0]);
        }
        catch (IOException iOException) {
            iSdkLog.error(iOException, null, new Object[0]);
        }
        return true;
    }

    private boolean deleteContentOf(File file) throws SecurityException {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory() && !this.deleteContentOf(file2)) {
                    return false;
                }
                if (file2.delete()) continue;
                return false;
            }
        }
        return true;
    }

    private File[] buildAvdFilesList() throws AndroidLocation.AndroidLocationException {
        File file = new File(this.getBaseAvdFolder());
        if (file.isFile()) {
            throw new AndroidLocation.AndroidLocationException(String.format("%1$s is not a valid folder.", file.getAbsolutePath()));
        }
        if (!file.exists()) {
            file.mkdirs();
            return null;
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                if (INI_NAME_PATTERN.matcher(string).matches()) {
                    boolean bl = new File(file, string).isFile();
                    return bl;
                }
                return false;
            }
        });
        return fileArray;
    }

    private void buildAvdList(ArrayList<AvdInfo> arrayList, ISdkLog iSdkLog) throws AndroidLocation.AndroidLocationException {
        File[] fileArray = this.buildAvdFilesList();
        if (fileArray != null) {
            for (File file : fileArray) {
                AvdInfo avdInfo = this.parseAvdInfo(file, iSdkLog);
                if (avdInfo == null) continue;
                arrayList.add(avdInfo);
            }
        }
    }

    private AvdInfo parseAvdInfo(File file, ISdkLog iSdkLog) {
        Comparable<AvdInfo> comparable;
        Object object;
        String string;
        Map<String, String> map = ProjectProperties.parsePropertyFile(new FileWrapper(file), iSdkLog);
        String string2 = map.get(AVD_INFO_PATH);
        String string3 = map.get(AVD_INFO_TARGET);
        IAndroidTarget iAndroidTarget = null;
        File file2 = null;
        Map<String, String> map2 = null;
        if (string3 != null) {
            iAndroidTarget = this.mSdkManager.getTargetFromHashString(string3);
        }
        if (string2 != null) {
            file2 = new FileWrapper(string2, CONFIG_INI);
        }
        if (file2 != null) {
            if (!file2.isFile()) {
                iSdkLog.warning("Missing file '%1$s'.", file2.getPath());
            } else {
                map2 = ProjectProperties.parsePropertyFile((IAbstractFile)((Object)file2), iSdkLog);
            }
        }
        String string4 = file.getName();
        Matcher matcher = INI_NAME_PATTERN.matcher(file.getName());
        if (matcher.matches()) {
            string4 = matcher.group(1);
        }
        String string5 = string = map2 == null ? null : map2.get(AVD_INI_ABI_TYPE);
        if (string == null) {
            string = "armeabi";
        }
        boolean bl = true;
        if (map2 != null && (object = map2.get(AVD_INI_IMAGES_1)) != null) {
            comparable = new File(this.mSdkManager.getLocation() + File.separator + (String)object);
            if (!((File)comparable).isDirectory()) {
                bl = false;
            } else {
                object = map2.get(AVD_INI_IMAGES_2);
                if (object != null && !((File)(comparable = new File(this.mSdkManager.getLocation() + File.separator + (String)object))).isDirectory()) {
                    bl = false;
                }
            }
        }
        object = string2 == null ? AvdInfo.AvdStatus.ERROR_PATH : (file2 == null ? AvdInfo.AvdStatus.ERROR_CONFIG : (string3 == null ? AvdInfo.AvdStatus.ERROR_TARGET_HASH : (iAndroidTarget == null ? AvdInfo.AvdStatus.ERROR_TARGET : (map2 == null ? AvdInfo.AvdStatus.ERROR_PROPERTIES : (!bl ? AvdInfo.AvdStatus.ERROR_IMAGE_DIR : AvdInfo.AvdStatus.OK)))));
        comparable = new AvdInfo(string4, file, string2, string3, iAndroidTarget, string, map2, (AvdInfo.AvdStatus)((Object)object));
        return comparable;
    }

    private static void writeIniFile(File file, Map<String, String> map) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            outputStreamWriter.write(String.format("%1$s=%2$s\n", entry.getKey(), entry.getValue()));
        }
        outputStreamWriter.close();
    }

    private boolean createSdCard(String string, String string2, String string3, ISdkLog iSdkLog) {
        try {
            String[] stringArray = new String[]{string, string2, string3};
            Process process = Runtime.getRuntime().exec(stringArray);
            final ArrayList arrayList = new ArrayList();
            final ArrayList arrayList2 = new ArrayList();
            int n = GrabProcessOutput.grabProcessOutput(process, GrabProcessOutput.Wait.WAIT_FOR_READERS, new GrabProcessOutput.IProcessOutput(){

                public void out(String string) {
                    if (string != null) {
                        arrayList2.add(string);
                    }
                }

                public void err(String string) {
                    if (string != null) {
                        arrayList.add(string);
                    }
                }
            });
            if (n == 0) {
                return true;
            }
            for (String string4 : arrayList) {
                iSdkLog.error(null, string4, new Object[0]);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        iSdkLog.error(null, "Failed to create the SD card.", new Object[0]);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAvd(AvdInfo avdInfo) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mAllAvdList.remove(avdInfo)) {
                this.mBrokenAvdList = null;
                this.mValidAvdList = null;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAvd(String string, ISdkLog iSdkLog) throws IOException {
        AvdInfo avdInfo = null;
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            for (AvdInfo avdInfo2 : this.mAllAvdList) {
                if (!avdInfo2.getName().equals(string)) continue;
                avdInfo = avdInfo2;
                break;
            }
        }
        if (avdInfo == null) {
            iSdkLog.error(null, "There is no Android Virtual Device named '%s'.", string);
            return;
        }
        this.updateAvd(avdInfo, iSdkLog);
    }

    public void updateAvd(AvdInfo avdInfo, ISdkLog iSdkLog) throws IOException {
        AvdInfo.AvdStatus avdStatus;
        Map<String, String> map = avdInfo.getProperties();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (map != null) {
            hashMap.putAll(map);
        }
        if (this.setImagePathProperties(avdInfo.getTarget(), avdInfo.getAbiType(), hashMap, iSdkLog)) {
            if (hashMap.containsKey(AVD_INI_IMAGES_1)) {
                iSdkLog.printf("Updated '%1$s' with value '%2$s'\n", AVD_INI_IMAGES_1, hashMap.get(AVD_INI_IMAGES_1));
            }
            if (hashMap.containsKey(AVD_INI_IMAGES_2)) {
                iSdkLog.printf("Updated '%1$s' with value '%2$s'\n", AVD_INI_IMAGES_2, hashMap.get(AVD_INI_IMAGES_2));
            }
            avdStatus = AvdInfo.AvdStatus.OK;
        } else {
            iSdkLog.error(null, "Unable to find non empty system images folders for %1$s", avdInfo.getName());
            avdStatus = AvdInfo.AvdStatus.ERROR_IMAGE_DIR;
        }
        File file = new File(avdInfo.getDataFolderPath(), CONFIG_INI);
        AvdManager.writeIniFile(file, hashMap);
        AvdInfo avdInfo2 = new AvdInfo(avdInfo.getName(), avdInfo.getIniFile(), avdInfo.getDataFolderPath(), avdInfo.getTargetHash(), avdInfo.getTarget(), avdInfo.getAbiType(), hashMap, avdStatus);
        this.replaceAvd(avdInfo, avdInfo2);
    }

    private boolean setImagePathProperties(IAndroidTarget iAndroidTarget, String string, Map<String, String> map, ISdkLog iSdkLog) {
        map.remove(AVD_INI_IMAGES_1);
        map.remove(AVD_INI_IMAGES_2);
        try {
            IAndroidTarget iAndroidTarget2;
            String string2 = AVD_INI_IMAGES_1;
            String string3 = this.getImageRelativePath(iAndroidTarget, string);
            if (string3 != null) {
                map.put(string2, string3);
                string2 = AVD_INI_IMAGES_2;
            }
            if ((iAndroidTarget2 = iAndroidTarget.getParent()) != null && (string3 = this.getImageRelativePath(iAndroidTarget2, string)) != null) {
                map.put(string2, string3);
            }
            return map.containsKey(AVD_INI_IMAGES_1);
        }
        catch (InvalidTargetPathException invalidTargetPathException) {
            iSdkLog.error(invalidTargetPathException, invalidTargetPathException.getMessage(), new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAvd(AvdInfo avdInfo, AvdInfo avdInfo2) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.remove(avdInfo);
            this.mAllAvdList.add(avdInfo2);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AvdConflict {
        NO_CONFLICT,
        CONFLICT_EXISTING_AVD,
        CONFLICT_INVALID_AVD,
        CONFLICT_EXISTING_PATH;

    }

    private static final class InvalidTargetPathException
    extends Exception {
        private static final long serialVersionUID = 1L;

        InvalidTargetPathException(String string) {
            super(string);
        }
    }
}

