/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.com.android.sdklib.internal.repository;

import com.crashlytics.reloc.com.android.sdklib.internal.repository.ITaskMonitor;
import com.crashlytics.reloc.com.android.sdklib.internal.repository.UrlOpener;
import com.crashlytics.reloc.com.android.sdklib.repository.SdkAddonsListConstants;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLKeyException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AddonsListFetcher {
    public Site[] fetch(ITaskMonitor iTaskMonitor, String string) {
        string = string == null ? "" : string.trim();
        iTaskMonitor.setProgressMax(5);
        iTaskMonitor.setDescription("Fetching %1$s", string);
        iTaskMonitor.incProgress(1);
        Exception[] exceptionArray = new Exception[]{null};
        Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        String[] stringArray = new String[]{null};
        Document document = null;
        String string2 = null;
        ByteArrayInputStream byteArrayInputStream = this.fetchUrl(string, iTaskMonitor.createSubMonitor(1), exceptionArray);
        if (byteArrayInputStream != null) {
            iTaskMonitor.setDescription("Validate XML", new Object[0]);
            int n = this.getXmlSchemaVersion(byteArrayInputStream);
            if (n >= 1 && n <= 1) {
                String string3 = this.validateXml(byteArrayInputStream, string, n, stringArray, booleanArray);
                if (string3 != null) {
                    document = this.getDocument(byteArrayInputStream, iTaskMonitor);
                    string2 = string3;
                }
            } else if (n > 1) {
                return null;
            }
        }
        if (exceptionArray[0] != null) {
            String string4 = null;
            string4 = exceptionArray[0] instanceof FileNotFoundException ? "File not found" : (exceptionArray[0] instanceof UnknownHostException && exceptionArray[0].getMessage() != null ? String.format("Unknown Host %1$s", exceptionArray[0].getMessage()) : (exceptionArray[0] instanceof SSLKeyException ? "HTTPS SSL error. You might want to force download through HTTP in the settings." : (exceptionArray[0].getMessage() != null ? exceptionArray[0].getMessage() : String.format("Unknown (%1$s)", exceptionArray[0].getClass().getName()))));
            iTaskMonitor.logError("Failed to fetch URL %1$s, reason: %2$s", string, string4);
        }
        if (stringArray[0] != null) {
            iTaskMonitor.logError("%s", stringArray[0]);
        }
        if (document == null) {
            return null;
        }
        iTaskMonitor.incProgress(1);
        Site[] siteArray = null;
        if (byteArrayInputStream != null) {
            iTaskMonitor.setDescription("Parse XML", new Object[0]);
            iTaskMonitor.incProgress(1);
            siteArray = this.parseAddonsList(document, string2, iTaskMonitor);
        }
        iTaskMonitor.incProgress(1);
        return siteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayInputStream fetchUrl(String string, ITaskMonitor iTaskMonitor, Exception[] exceptionArray) {
        Object object;
        block12: {
            InputStream inputStream = null;
            int n = 65536;
            int n2 = 0;
            Object object2 = new byte[n];
            try {
                int n3;
                inputStream = UrlOpener.openUrl(string, iTaskMonitor);
                while ((n3 = inputStream.read((byte[])object2, n2, ((byte[])object2).length - n2)) != -1) {
                    if ((n2 += n3) != ((byte[])object2).length) continue;
                    object = new byte[n2 + n];
                    System.arraycopy(object2, 0, object, 0, n2);
                    object2 = object;
                }
                object = new ByteArrayInputStream((byte[])object2, 0, n2);
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    if (exceptionArray != null) {
                        exceptionArray[0] = exception;
                    }
                    return null;
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return object;
    }

    protected int getXmlSchemaVersion(InputStream inputStream) {
        Object object;
        Object object2;
        if (inputStream == null) {
            return 0;
        }
        Node node = null;
        try {
            inputStream.reset();
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setIgnoringComments(false);
            ((DocumentBuilderFactory)object2).setValidating(false);
            ((DocumentBuilderFactory)object2).setNamespaceAware(false);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            ((DocumentBuilder)object).setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException sAXParseException) throws SAXException {
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }

                public void error(SAXParseException sAXParseException) throws SAXException {
                    throw sAXParseException;
                }
            });
            node = ((DocumentBuilder)object).parse(inputStream);
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (node == null) {
            return 0;
        }
        object2 = Pattern.compile("http://schemas.android.com/sdk/android/addons-list/([1-9][0-9]*)");
        object = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Matcher matcher;
            String string;
            Node node3;
            if (node2.getNodeType() != 1) continue;
            object = null;
            String string2 = node2.getNodeName();
            int n = string2.indexOf(58);
            if (n > 0 && n < string2.length() - 1) {
                object = string2.substring(0, n);
                string2 = string2.substring(n + 1);
            }
            if (!"sdk-addons-list".equals(string2)) continue;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            String string3 = "xmlns";
            if (object != null) {
                string3 = string3 + ":" + (String)object;
            }
            if ((node3 = namedNodeMap.getNamedItem(string3)) == null || (string = node3.getNodeValue()) == null || !(matcher = ((Pattern)object2).matcher(string)).matches()) continue;
            String string4 = matcher.group(1);
            try {
                return Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }
        return 0;
    }

    protected String validateXml(InputStream inputStream, String string, int n, String[] stringArray, Boolean[] booleanArray) {
        if (inputStream == null) {
            return null;
        }
        try {
            Validator validator = this.getValidator(n);
            if (validator == null) {
                booleanArray[0] = Boolean.FALSE;
                stringArray[0] = String.format("XML verification failed for %1$s.\nNo suitable XML Schema Validator could be found in your Java environment. Please consider updating your version of Java.", string);
                return null;
            }
            booleanArray[0] = Boolean.TRUE;
            inputStream.reset();
            validator.validate(new StreamSource(inputStream));
            return SdkAddonsListConstants.getSchemaUri(n);
        }
        catch (SAXParseException sAXParseException) {
            stringArray[0] = String.format("XML verification failed for %1$s.\nLine %2$d:%3$d, Error: %4$s", string, sAXParseException.getLineNumber(), sAXParseException.getColumnNumber(), sAXParseException.toString());
        }
        catch (Exception exception) {
            stringArray[0] = String.format("XML verification failed for %1$s.\nError: %2$s", string, exception.toString());
        }
        return null;
    }

    private Validator getValidator(int n) throws SAXException {
        InputStream inputStream = SdkAddonsListConstants.getXsdStream(n);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (schemaFactory == null) {
            return null;
        }
        Schema schema = schemaFactory.newSchema(new StreamSource(inputStream));
        Validator validator = schema == null ? null : schema.newValidator();
        return validator;
    }

    protected Document getDocument(InputStream inputStream, ITaskMonitor iTaskMonitor) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            inputStream.reset();
            Document document = documentBuilder.parse(new InputSource(inputStream));
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            iTaskMonitor.logError("Failed to create XML document builder", new Object[0]);
        }
        catch (SAXException sAXException) {
            iTaskMonitor.logError("Failed to parse XML document", new Object[0]);
        }
        catch (IOException iOException) {
            iTaskMonitor.logError("Failed to read XML document", new Object[0]);
        }
        return null;
    }

    protected Site[] parseAddonsList(Document document, String string, ITaskMonitor iTaskMonitor) {
        Node node;
        String string2 = System.getenv("SDK_TEST_BASE_URL");
        if (!(string2 == null || string2.length() > 0 && string2.endsWith("/"))) {
            string2 = null;
        }
        if ((node = this.getFirstChild(document, string, "sdk-addons-list")) != null) {
            ArrayList<Site> arrayList = new ArrayList<Site>();
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 1 || !string.equals(node2.getNamespaceURI()) || !node2.getLocalName().equals("addon-site")) continue;
                Node node3 = this.getFirstChild(node2, string, "url");
                Node node4 = this.getFirstChild(node2, string, "name");
                if (node4 == null || node3 == null) continue;
                String string3 = node3.getTextContent().trim();
                String string4 = node4.getTextContent().trim();
                if (string2 != null && string3.startsWith("https://dl-ssl.google.com/android/repository/")) {
                    string3 = string2 + string3.substring("https://dl-ssl.google.com/android/repository/".length());
                }
                if (string3.length() <= 0 || string4.length() <= 0) continue;
                arrayList.add(new Site(string3, string4));
            }
            return arrayList.toArray(new Site[arrayList.size()]);
        }
        return null;
    }

    private Node getFirstChild(Node node, String string, String string2) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !string.equals(node2.getNamespaceURI()) || string2 != null && !node2.getLocalName().equals(string2)) continue;
            return node2;
        }
        return null;
    }

    public static class Site {
        private final String mUrl;
        private final String mUiName;

        private Site(String string, String string2) {
            this.mUrl = string.trim();
            this.mUiName = string2;
        }

        public String getUrl() {
            return this.mUrl;
        }

        public String getUiName() {
            return this.mUiName;
        }
    }
}

