/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.ant;

import com.crashlytics.reloc.org.apache.ivy.Ivy;
import com.crashlytics.reloc.org.apache.ivy.ant.AntMessageLogger;
import com.crashlytics.reloc.org.apache.ivy.ant.IvyTask;
import com.crashlytics.reloc.org.apache.ivy.core.IvyContext;
import com.crashlytics.reloc.org.apache.ivy.core.cache.DefaultRepositoryCacheManager;
import com.crashlytics.reloc.org.apache.ivy.core.cache.RepositoryCacheManager;
import com.crashlytics.reloc.org.apache.ivy.core.settings.IvySettings;
import com.crashlytics.reloc.org.apache.ivy.osgi.obr.xml.OBRXMLWriter;
import com.crashlytics.reloc.org.apache.ivy.osgi.repo.FSManifestIterable;
import com.crashlytics.reloc.org.apache.ivy.osgi.repo.ResolverManifestIterable;
import com.crashlytics.reloc.org.apache.ivy.plugins.resolver.BasicResolver;
import com.crashlytics.reloc.org.apache.ivy.plugins.resolver.DependencyResolver;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import com.crashlytics.reloc.org.apache.tools.ant.BuildException;
import com.crashlytics.reloc.org.apache.tools.ant.ProjectComponent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.transform.TransformerConfigurationException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BuildBundleRepoDescriptorTask
extends IvyTask {
    private String resolverName = null;
    private File file = null;
    private String cacheName = null;
    private String encoding = "UTF-8";
    private boolean indent = true;
    private File baseDir;
    private boolean quiet;

    public void setResolver(String resolverName) {
        this.resolverName = resolverName;
    }

    public void setCache(String cacheName) {
        this.cacheName = cacheName;
    }

    public void setOut(File file) {
        this.file = file;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setBaseDir(File dir) {
        this.baseDir = dir;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    protected void prepareTask() {
        if (this.baseDir == null) {
            super.prepareTask();
        }
    }

    public void doExecute() throws BuildException {
        ContentHandler hd;
        FileOutputStream out;
        Iterator it;
        Ivy ivy;
        if (this.file == null) {
            throw new BuildException("No output file specified: use the attribute 'out'");
        }
        if (this.resolverName != null) {
            if (this.baseDir != null) {
                throw new BuildException("specify only one of 'resolver' or 'baseDir'");
            }
            if (this.cacheName != null) {
                throw new BuildException("specify only one of 'resolver' or 'cache'");
            }
            ivy = this.getIvyInstance();
            IvySettings settings = ivy.getSettings();
            DependencyResolver resolver = settings.getResolver(this.resolverName);
            if (resolver == null) {
                throw new BuildException("the resolver '" + this.resolverName + "' was not found");
            }
            if (!(resolver instanceof BasicResolver)) {
                throw new BuildException("the type of resolver '" + resolver.getClass().getName() + "' is not supported.");
            }
            it = new ResolverManifestIterable((BasicResolver)resolver).iterator();
        } else if (this.baseDir != null) {
            if (this.cacheName != null) {
                throw new BuildException("specify only one of 'baseDir' or 'cache'");
            }
            if (!this.baseDir.isDirectory()) {
                throw new BuildException(this.baseDir + " is not a directory");
            }
            it = new FSManifestIterable(this.baseDir).iterator();
        } else if (this.cacheName != null) {
            ivy = this.getIvyInstance();
            RepositoryCacheManager cacheManager = ivy.getSettings().getRepositoryCacheManager(this.cacheName);
            if (!(cacheManager instanceof DefaultRepositoryCacheManager)) {
                throw new BuildException("the type of cache '" + cacheManager.getClass().getName() + "' is not supported.");
            }
            File basedir = ((DefaultRepositoryCacheManager)cacheManager).getBasedir();
            it = new FSManifestIterable(basedir).iterator();
        } else {
            throw new BuildException("No resolver, cache or basedir specified: please provide one of them through the attribute 'resolver', 'cache' or 'dir'");
        }
        try {
            out = new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new BuildException(this.file + " was not found", (Throwable)e);
        }
        try {
            hd = OBRXMLWriter.newHandler(out, this.encoding, this.indent);
        }
        catch (TransformerConfigurationException e) {
            throw new BuildException("Sax configuration error: " + e.getMessage(), (Throwable)e);
        }
        IvyContext.getContext().getMessageLogger();
        class AntMessageLogger2
        extends AntMessageLogger {
            AntMessageLogger2() {
                super((ProjectComponent)BuildBundleRepoDescriptorTask.this);
            }
        }
        Message.setDefaultLogger(new AntMessageLogger2());
        try {
            OBRXMLWriter.writeManifests(it, hd, this.quiet);
        }
        catch (SAXException e) {
            throw new BuildException("Sax serialisation error: " + e.getMessage(), (Throwable)e);
        }
        try {
            out.flush();
            ((OutputStream)out).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Message.sumupProblems();
    }
}

