/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.ant;

import com.crashlytics.reloc.org.apache.ivy.ant.PackageMapping;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.tools.ant.BuildException;
import com.crashlytics.reloc.org.apache.tools.ant.Task;
import com.crashlytics.reloc.org.apache.tools.ant.filters.ChainableReader;
import com.crashlytics.reloc.org.apache.tools.ant.filters.LineContainsRegExp;
import com.crashlytics.reloc.org.apache.tools.ant.filters.TokenFilter;
import com.crashlytics.reloc.org.apache.tools.ant.taskdefs.Concat;
import com.crashlytics.reloc.org.apache.tools.ant.types.FileSet;
import com.crashlytics.reloc.org.apache.tools.ant.types.FilterChain;
import com.crashlytics.reloc.org.apache.tools.ant.types.RegularExpression;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IvyExtractFromSources
extends Task {
    private String organisation;
    private String module;
    private String revision;
    private String status;
    private List ignoredPackaged = new ArrayList();
    private Map mapping = new HashMap();
    private Concat concat = new Concat();
    private File to;

    public void addConfiguredIgnore(Ignore ignore) {
        this.ignoredPackaged.add(ignore.getPackage());
    }

    public File getTo() {
        return this.to;
    }

    public void setTo(File to) {
        this.to = to;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void addConfiguredMapping(PackageMapping mapping) {
        this.mapping.put(mapping.getPackage(), mapping.getModuleRevisionId());
    }

    public void addFileSet(FileSet fileSet) {
        this.concat.addFileset(fileSet);
    }

    public void execute() throws BuildException {
        ModuleRevisionId mrid;
        this.configureConcat();
        StringWriter out = new StringWriter();
        this.concat.setWriter((Writer)out);
        this.concat.execute();
        HashSet<String> importsSet = new HashSet<String>(Arrays.asList(((Object)out).toString().split("\n")));
        HashSet<ModuleRevisionId> dependencies = new HashSet<ModuleRevisionId>();
        Iterator iter = importsSet.iterator();
        while (iter.hasNext()) {
            String pack = ((String)iter.next()).trim();
            mrid = this.getMapping(pack);
            if (mrid == null) continue;
            dependencies.add(mrid);
        }
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(this.to));
            writer.println("<ivy-module version=\"1.0\">");
            writer.println("\t<info organisation=\"" + this.organisation + "\"");
            writer.println("\t       module=\"" + this.module + "\"");
            if (this.revision != null) {
                writer.println("\t       revision=\"" + this.revision + "\"");
            }
            if (this.status != null) {
                writer.println("\t       status=\"" + this.status + "\"");
            } else {
                writer.println("\t       status=\"integration\"");
            }
            writer.println("\t/>");
            if (!dependencies.isEmpty()) {
                writer.println("\t<dependencies>");
                Iterator iter2 = dependencies.iterator();
                while (iter2.hasNext()) {
                    mrid = (ModuleRevisionId)iter2.next();
                    writer.println("\t\t<dependency org=\"" + mrid.getOrganisation() + "\" name=\"" + mrid.getName() + "\" rev=\"" + mrid.getRevision() + "\"/>");
                }
                writer.println("\t</dependencies>");
            }
            writer.println("</ivy-module>");
            writer.close();
            this.log(dependencies.size() + " dependencies put in " + this.to);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("impossible to create file " + this.to + ": " + e, (Throwable)e);
        }
    }

    private ModuleRevisionId getMapping(String pack) {
        String askedPack = pack;
        ModuleRevisionId ret = null;
        while (ret == null && pack.length() > 0) {
            if (this.ignoredPackaged.contains(pack)) {
                return null;
            }
            ret = (ModuleRevisionId)this.mapping.get(pack);
            int lastDotIndex = pack.lastIndexOf(46);
            if (lastDotIndex == -1) break;
            pack = pack.substring(0, lastDotIndex);
        }
        if (ret == null) {
            this.log("no mapping found for " + askedPack, 3);
        }
        return ret;
    }

    private void configureConcat() {
        this.concat.setProject(this.getProject());
        this.concat.setTaskName(this.getTaskName());
        FilterChain filterChain = new FilterChain();
        LineContainsRegExp lcre = new LineContainsRegExp();
        RegularExpression regexp = new RegularExpression();
        regexp.setPattern("^import .+;");
        lcre.addConfiguredRegexp(regexp);
        filterChain.add((ChainableReader)lcre);
        TokenFilter tf = new TokenFilter();
        TokenFilter.ReplaceRegex rre = new TokenFilter.ReplaceRegex();
        rre.setPattern("import (.+);.*");
        rre.setReplace("\\1");
        tf.add((TokenFilter.Filter)rre);
        filterChain.add((ChainableReader)tf);
        this.concat.addFilterChain(filterChain);
    }

    public static class Ignore {
        private String packageName;

        public String getPackage() {
            return this.packageName;
        }

        public void setPackage(String package1) {
            this.packageName = package1;
        }
    }
}

