/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.core;

import com.crashlytics.reloc.org.apache.ivy.Ivy;
import com.crashlytics.reloc.org.apache.ivy.core.event.EventManager;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.ResolveData;
import com.crashlytics.reloc.org.apache.ivy.core.settings.IvySettings;
import com.crashlytics.reloc.org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import com.crashlytics.reloc.org.apache.ivy.util.MessageLogger;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class IvyContext {
    private static ThreadLocal current = new ThreadLocal();
    private Ivy defaultIvy;
    private WeakReference ivy = new WeakReference<Object>(null);
    private Map contextMap = new HashMap();
    private Thread operatingThread;
    private ResolveData resolveData;
    private DependencyDescriptor dd;

    public IvyContext() {
    }

    public IvyContext(IvyContext ctx) {
        this.defaultIvy = ctx.defaultIvy;
        this.ivy = ctx.ivy;
        this.contextMap = new HashMap(ctx.contextMap);
        this.operatingThread = ctx.operatingThread;
        this.resolveData = ctx.resolveData;
        this.dd = ctx.dd;
    }

    public static IvyContext getContext() {
        Stack cur = IvyContext.getCurrentStack();
        if (cur.isEmpty()) {
            cur.push(new IvyContext());
        }
        return (IvyContext)cur.peek();
    }

    private static Stack getCurrentStack() {
        Stack cur = (Stack)current.get();
        if (cur == null) {
            cur = new Stack();
            current.set(cur);
        }
        return cur;
    }

    public static IvyContext pushNewContext() {
        return IvyContext.pushContext(new IvyContext());
    }

    public static IvyContext pushNewCopyContext() {
        return IvyContext.pushContext(new IvyContext(IvyContext.getContext()));
    }

    public static IvyContext pushContext(IvyContext context) {
        IvyContext.getCurrentStack().push(context);
        return context;
    }

    public static IvyContext popContext() {
        return (IvyContext)IvyContext.getCurrentStack().pop();
    }

    public static Object peekInContextStack(String key) {
        Object value = null;
        Stack contextStack = IvyContext.getCurrentStack();
        for (int i = contextStack.size() - 1; i >= 0 && value == null; --i) {
            IvyContext ctx = (IvyContext)contextStack.get(i);
            value = ctx.peek(key);
        }
        return value;
    }

    public Ivy getIvy() {
        Ivy ivy = this.peekIvy();
        return ivy == null ? this.getDefaultIvy() : ivy;
    }

    public Ivy peekIvy() {
        Ivy ivy = (Ivy)this.ivy.get();
        return ivy;
    }

    private Ivy getDefaultIvy() {
        if (this.defaultIvy == null) {
            this.defaultIvy = Ivy.newInstance();
            try {
                this.defaultIvy.configureDefault();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultIvy;
    }

    public void setIvy(Ivy ivy) {
        this.ivy = new WeakReference<Ivy>(ivy);
        this.operatingThread = Thread.currentThread();
    }

    public IvySettings getSettings() {
        return this.getIvy().getSettings();
    }

    public CircularDependencyStrategy getCircularDependencyStrategy() {
        return this.getSettings().getCircularDependencyStrategy();
    }

    public Object get(String key) {
        WeakReference ref = (WeakReference)this.contextMap.get(key);
        return ref == null ? null : ref.get();
    }

    public void set(String key, Object value) {
        this.contextMap.put(key, new WeakReference<Object>(value));
    }

    public Object peek(String key) {
        Map map = this.contextMap;
        synchronized (map) {
            Object o = this.contextMap.get(key);
            if (o == null) {
                return null;
            }
            if (o instanceof List) {
                if (((List)o).size() == 0) {
                    return null;
                }
                Object ret = ((List)o).get(0);
                return ret;
            }
            throw new RuntimeException("Cannot top from non List object " + o);
        }
    }

    public Object pop(String key) {
        Map map = this.contextMap;
        synchronized (map) {
            Object o = this.contextMap.get(key);
            if (o == null) {
                return null;
            }
            if (o instanceof List) {
                if (((List)o).size() == 0) {
                    return null;
                }
                Object ret = ((List)o).remove(0);
                return ret;
            }
            throw new RuntimeException("Cannot pop from non List object " + o);
        }
    }

    public boolean pop(String key, Object expectedValue) {
        Map map = this.contextMap;
        synchronized (map) {
            Object o = this.contextMap.get(key);
            if (o == null) {
                return false;
            }
            if (o instanceof List) {
                if (((List)o).size() == 0) {
                    return false;
                }
                Object top = ((List)o).get(0);
                if (!top.equals(expectedValue)) {
                    return false;
                }
                ((List)o).remove(0);
                return true;
            }
            throw new RuntimeException("Cannot pop from non List object " + o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(String key, Object value) {
        Map map = this.contextMap;
        synchronized (map) {
            Object o;
            if (!this.contextMap.containsKey(key)) {
                this.contextMap.put(key, new LinkedList());
            }
            if (!((o = this.contextMap.get(key)) instanceof List)) {
                throw new RuntimeException("Cannot push to non List object " + o);
            }
            ((List)o).add(0, value);
        }
    }

    public Thread getOperatingThread() {
        return this.operatingThread;
    }

    public MessageLogger getMessageLogger() {
        Ivy ivy = this.peekIvy();
        if (ivy == null) {
            if (this.defaultIvy == null) {
                return Message.getDefaultLogger();
            }
            return this.defaultIvy.getLoggerEngine();
        }
        return ivy.getLoggerEngine();
    }

    public EventManager getEventManager() {
        return this.getIvy().getEventManager();
    }

    public void checkInterrupted() {
        this.getIvy().checkInterrupted();
    }

    public void setResolveData(ResolveData data) {
        this.resolveData = data;
    }

    public ResolveData getResolveData() {
        return this.resolveData;
    }

    public void setDependencyDescriptor(DependencyDescriptor dd) {
        this.dd = dd;
    }

    public DependencyDescriptor getDependencyDescriptor() {
        return this.dd;
    }
}

