/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.core.cache;

import com.crashlytics.reloc.org.apache.ivy.core.RelativeUrlResolver;
import com.crashlytics.reloc.org.apache.ivy.core.cache.ResolutionCacheManager;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleId;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.ivy.core.module.status.StatusManager;
import com.crashlytics.reloc.org.apache.ivy.plugins.conflict.ConflictManager;
import com.crashlytics.reloc.org.apache.ivy.plugins.matcher.PatternMatcher;
import com.crashlytics.reloc.org.apache.ivy.plugins.namespace.Namespace;
import com.crashlytics.reloc.org.apache.ivy.plugins.parser.ParserSettings;
import com.crashlytics.reloc.org.apache.ivy.plugins.resolver.DependencyResolver;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

class ParserSettingsMonitor {
    private ParserSettings delegatedSettings;
    private final Map substitutes;
    private ParserSettings monitoredSettings = new ParserSettings(){

        public ConflictManager getConflictManager(String name) {
            return ParserSettingsMonitor.this.delegatedSettings.getConflictManager(name);
        }

        public PatternMatcher getMatcher(String matcherName) {
            return ParserSettingsMonitor.this.delegatedSettings.getMatcher(matcherName);
        }

        public Namespace getNamespace(String namespace) {
            return ParserSettingsMonitor.this.delegatedSettings.getNamespace(namespace);
        }

        public RelativeUrlResolver getRelativeUrlResolver() {
            return ParserSettingsMonitor.this.delegatedSettings.getRelativeUrlResolver();
        }

        public ResolutionCacheManager getResolutionCacheManager() {
            return ParserSettingsMonitor.this.delegatedSettings.getResolutionCacheManager();
        }

        public DependencyResolver getResolver(ModuleRevisionId mRevId) {
            return ParserSettingsMonitor.this.delegatedSettings.getResolver(mRevId);
        }

        public StatusManager getStatusManager() {
            return ParserSettingsMonitor.this.delegatedSettings.getStatusManager();
        }

        public File resolveFile(String filename) {
            return ParserSettingsMonitor.this.delegatedSettings.resolveFile(filename);
        }

        public String getDefaultBranch(ModuleId moduleId) {
            return ParserSettingsMonitor.this.delegatedSettings.getDefaultBranch(moduleId);
        }

        public Namespace getContextNamespace() {
            return ParserSettingsMonitor.this.delegatedSettings.getContextNamespace();
        }

        public Map substitute(Map strings) {
            LinkedHashMap substituted = new LinkedHashMap();
            Iterator it = strings.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                substituted.put(entry.getKey(), this.substitute((String)entry.getValue()));
            }
            return substituted;
        }

        public String substitute(String value) {
            String r = ParserSettingsMonitor.this.delegatedSettings.substitute(value);
            if (value != null && value != r) {
                ParserSettingsMonitor.this.substitutes.put(value, r);
            }
            return r;
        }
    };

    public ParserSettingsMonitor(ParserSettings settings) {
        this.delegatedSettings = settings;
        this.substitutes = new HashMap();
    }

    public ParserSettings getMonitoredSettings() {
        return this.monitoredSettings;
    }

    public void endMonitoring() {
        this.monitoredSettings = null;
        this.delegatedSettings = null;
    }

    public boolean hasChanged(ParserSettings newSettings) {
        Iterator it = this.substitutes.entrySet().iterator();
        while (it.hasNext()) {
            String newValue;
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            Object oldValue = entry.getValue();
            if (oldValue.equals(newValue = newSettings.substitute(key))) continue;
            Message.debug("settings variable has changed for : " + entry.getKey());
            return true;
        }
        return false;
    }
}

