/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.core.report;

import com.crashlytics.reloc.org.apache.ivy.core.cache.ResolutionCacheManager;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleId;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.ivy.core.report.ArtifactDownloadReport;
import com.crashlytics.reloc.org.apache.ivy.core.report.ConfigurationResolveReport;
import com.crashlytics.reloc.org.apache.ivy.core.report.DownloadStatus;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.IvyNode;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.ResolveOptions;
import com.crashlytics.reloc.org.apache.ivy.plugins.report.ReportOutputter;
import com.crashlytics.reloc.org.apache.ivy.util.filter.Filter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ResolveReport {
    private ModuleDescriptor md;
    private Map confReports = new LinkedHashMap();
    private List problemMessages = new ArrayList();
    private List dependencies = new ArrayList();
    private List artifacts = new ArrayList();
    private long resolveTime;
    private long downloadTime;
    private String resolveId;
    private long downloadSize;

    public ResolveReport(ModuleDescriptor md) {
        this(md, ResolveOptions.getDefaultResolveId(md));
    }

    public ResolveReport(ModuleDescriptor md, String resolveId) {
        this.md = md;
        this.resolveId = resolveId;
    }

    public void addReport(String conf, ConfigurationResolveReport report) {
        this.confReports.put(conf, report);
    }

    public ConfigurationResolveReport getConfigurationReport(String conf) {
        return (ConfigurationResolveReport)this.confReports.get(conf);
    }

    public String[] getConfigurations() {
        return this.confReports.keySet().toArray(new String[this.confReports.size()]);
    }

    public boolean hasError() {
        boolean hasError;
        ConfigurationResolveReport report;
        Iterator it = this.confReports.values().iterator();
        for (hasError = false; it.hasNext() && !hasError; hasError |= report.hasError()) {
            report = (ConfigurationResolveReport)it.next();
        }
        return hasError;
    }

    public void output(ReportOutputter[] outputters, ResolutionCacheManager cacheMgr, ResolveOptions options) throws IOException {
        for (int i = 0; i < outputters.length; ++i) {
            outputters[i].output(this, cacheMgr, options);
        }
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.md;
    }

    public IvyNode[] getEvictedNodes() {
        LinkedHashSet<IvyNode> all = new LinkedHashSet<IvyNode>();
        Iterator iter = this.confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            all.addAll(Arrays.asList(report.getEvictedNodes()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public IvyNode[] getUnresolvedDependencies() {
        LinkedHashSet<IvyNode> all = new LinkedHashSet<IvyNode>();
        Iterator iter = this.confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            all.addAll(Arrays.asList(report.getUnresolvedDependencies()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        return ConfigurationResolveReport.filterOutMergedArtifacts(this.getArtifactsReports(DownloadStatus.FAILED, true));
    }

    public ArtifactDownloadReport[] getAllArtifactsReports() {
        return this.getArtifactsReports(null, true);
    }

    public ArtifactDownloadReport[] getArtifactsReports(DownloadStatus downloadStatus, boolean withEvicted) {
        LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
        Iterator iter = this.confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            ArtifactDownloadReport[] reports = report.getArtifactsReports(downloadStatus, withEvicted);
            all.addAll(Arrays.asList(reports));
        }
        return all.toArray(new ArtifactDownloadReport[all.size()]);
    }

    public ArtifactDownloadReport[] getArtifactsReports(ModuleRevisionId mrid) {
        LinkedHashSet<ArtifactDownloadReport> all = new LinkedHashSet<ArtifactDownloadReport>();
        Iterator iter = this.confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            all.addAll(Arrays.asList(report.getDownloadReports(mrid)));
        }
        return all.toArray(new ArtifactDownloadReport[all.size()]);
    }

    public void checkIfChanged() {
        Iterator iter = this.confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            report.checkIfChanged();
        }
    }

    public boolean hasChanged() {
        Iterator iter = this.confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            if (!report.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void setProblemMessages(List problems) {
        this.problemMessages = problems;
    }

    public List getProblemMessages() {
        return this.problemMessages;
    }

    public List getAllProblemMessages() {
        ArrayList<String> ret = new ArrayList<String>(this.problemMessages);
        Iterator iter = this.confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport r = (ConfigurationResolveReport)iter.next();
            IvyNode[] unresolved = r.getUnresolvedDependencies();
            for (int i = 0; i < unresolved.length; ++i) {
                String errMsg = unresolved[i].getProblemMessage();
                if (errMsg.length() > 0) {
                    ret.add("unresolved dependency: " + unresolved[i].getId() + ": " + errMsg);
                    continue;
                }
                ret.add("unresolved dependency: " + unresolved[i].getId());
            }
            ArtifactDownloadReport[] adrs = r.getFailedArtifactsReports();
            for (int i = 0; i < adrs.length; ++i) {
                ret.add("download failed: " + adrs[i].getArtifact());
            }
        }
        return ret;
    }

    public void setDependencies(List dependencies, Filter artifactFilter) {
        this.dependencies = dependencies;
        this.artifacts = new ArrayList();
        Iterator iter = dependencies.iterator();
        while (iter.hasNext()) {
            IvyNode dependency = (IvyNode)iter.next();
            if (!dependency.isCompletelyEvicted() && !dependency.hasProblem()) {
                this.artifacts.addAll(Arrays.asList(dependency.getSelectedArtifacts(artifactFilter)));
            }
            String[] dconfs = dependency.getRootModuleConfigurations();
            for (int j = 0; j < dconfs.length; ++j) {
                ConfigurationResolveReport configurationReport = this.getConfigurationReport(dconfs[j]);
                if (configurationReport == null) continue;
                configurationReport.addDependency(dependency);
            }
        }
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public List getArtifacts() {
        return this.artifacts;
    }

    public List getModuleIds() {
        ArrayList<ModuleId> ret = new ArrayList<ModuleId>();
        ArrayList sortedDependencies = new ArrayList(this.dependencies);
        Iterator iter = sortedDependencies.iterator();
        while (iter.hasNext()) {
            IvyNode dependency = (IvyNode)iter.next();
            ModuleId mid = dependency.getResolvedId().getModuleId();
            if (ret.contains(mid)) continue;
            ret.add(mid);
        }
        return ret;
    }

    public void setResolveTime(long elapsedTime) {
        this.resolveTime = elapsedTime;
    }

    public long getResolveTime() {
        return this.resolveTime;
    }

    public void setDownloadTime(long elapsedTime) {
        this.downloadTime = elapsedTime;
    }

    public long getDownloadTime() {
        return this.downloadTime;
    }

    public void setDownloadSize(long size) {
        this.downloadSize = size;
    }

    public long getDownloadSize() {
        return this.downloadSize;
    }

    public String getResolveId() {
        return this.resolveId;
    }
}

