/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.core.retrieve;

import com.crashlytics.reloc.org.apache.ivy.core.IvyContext;
import com.crashlytics.reloc.org.apache.ivy.core.IvyPatternHelper;
import com.crashlytics.reloc.org.apache.ivy.core.cache.ResolutionCacheManager;
import com.crashlytics.reloc.org.apache.ivy.core.event.EventManager;
import com.crashlytics.reloc.org.apache.ivy.core.event.retrieve.EndRetrieveArtifactEvent;
import com.crashlytics.reloc.org.apache.ivy.core.event.retrieve.EndRetrieveEvent;
import com.crashlytics.reloc.org.apache.ivy.core.event.retrieve.StartRetrieveArtifactEvent;
import com.crashlytics.reloc.org.apache.ivy.core.event.retrieve.StartRetrieveEvent;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.Artifact;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ArtifactRevisionId;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleId;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.ivy.core.report.ArtifactDownloadReport;
import com.crashlytics.reloc.org.apache.ivy.core.resolve.ResolveOptions;
import com.crashlytics.reloc.org.apache.ivy.core.retrieve.RetrieveEngineSettings;
import com.crashlytics.reloc.org.apache.ivy.core.retrieve.RetrieveOptions;
import com.crashlytics.reloc.org.apache.ivy.core.retrieve.RetrieveReport;
import com.crashlytics.reloc.org.apache.ivy.plugins.report.XmlReportParser;
import com.crashlytics.reloc.org.apache.ivy.util.FileUtil;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RetrieveEngine {
    private static final int KILO = 1024;
    private RetrieveEngineSettings settings;
    private EventManager eventManager;

    public RetrieveEngine(RetrieveEngineSettings settings, EventManager eventManager) {
        this.settings = settings;
        this.eventManager = eventManager;
    }

    public int retrieve(ModuleRevisionId mrid, String destFilePattern, RetrieveOptions options) throws IOException {
        RetrieveOptions retieveOptions = new RetrieveOptions(options);
        retieveOptions.setDestArtifactPattern(destFilePattern);
        RetrieveReport result = this.retrieve(mrid, retieveOptions);
        return result.getNbrArtifactsCopied();
    }

    public RetrieveReport retrieve(ModuleRevisionId mrid, RetrieveOptions options) throws IOException {
        RetrieveReport report = new RetrieveReport();
        ModuleId moduleId = mrid.getModuleId();
        if ("default".equals(options.getLog())) {
            Message.info(":: retrieving :: " + moduleId + (options.isSync() ? " [sync]" : ""));
        } else {
            Message.verbose(":: retrieving :: " + moduleId + (options.isSync() ? " [sync]" : ""));
        }
        Message.verbose("\tcheckUpToDate=" + this.settings.isCheckUpToDate());
        long start = System.currentTimeMillis();
        String destFilePattern = IvyPatternHelper.substituteVariables(options.getDestArtifactPattern(), this.settings.getVariables());
        String destIvyPattern = IvyPatternHelper.substituteVariables(options.getDestIvyPattern(), this.settings.getVariables());
        String[] confs = this.getConfs(mrid, options);
        if ("default".equals(options.getLog())) {
            Message.info("\tconfs: " + Arrays.asList(confs));
        } else {
            Message.verbose("\tconfs: " + Arrays.asList(confs));
        }
        if (this.eventManager != null) {
            this.eventManager.fireIvyEvent(new StartRetrieveEvent(mrid, confs, options));
        }
        try {
            Map artifactsToCopy = this.determineArtifactsToCopy(mrid, destFilePattern, options);
            File fileRetrieveRoot = this.settings.resolveFile(IvyPatternHelper.getTokenRoot(destFilePattern));
            report.setRetrieveRoot(fileRetrieveRoot);
            File ivyRetrieveRoot = destIvyPattern == null ? null : this.settings.resolveFile(IvyPatternHelper.getTokenRoot(destIvyPattern));
            HashSet targetArtifactsStructure = new HashSet();
            HashSet targetIvysStructure = new HashSet();
            long totalCopiedSize = 0L;
            Iterator iter = artifactsToCopy.keySet().iterator();
            while (iter.hasNext()) {
                ArtifactDownloadReport artifact = (ArtifactDownloadReport)iter.next();
                File archive = artifact.getLocalFile();
                if (archive == null) {
                    Message.verbose("\tno local file available for " + artifact + ": skipping");
                    continue;
                }
                Set dest = (Set)artifactsToCopy.get(artifact);
                Message.verbose("\tretrieving " + archive);
                Iterator it2 = dest.iterator();
                while (it2.hasNext()) {
                    IvyContext.getContext().checkInterrupted();
                    File destFile = this.settings.resolveFile((String)it2.next());
                    if (!this.settings.isCheckUpToDate() || !this.upToDate(archive, destFile, options)) {
                        Message.verbose("\t\tto " + destFile);
                        if (this.eventManager != null) {
                            this.eventManager.fireIvyEvent(new StartRetrieveArtifactEvent(artifact, destFile));
                        }
                        if (options.isMakeSymlinks()) {
                            FileUtil.symlink(archive, destFile, null, true);
                        } else {
                            FileUtil.copy(archive, destFile, null, true);
                        }
                        if (this.eventManager != null) {
                            this.eventManager.fireIvyEvent(new EndRetrieveArtifactEvent(artifact, destFile));
                        }
                        totalCopiedSize += destFile.length();
                        report.addCopiedFile(destFile, artifact);
                    } else {
                        Message.verbose("\t\tto " + destFile + " [NOT REQUIRED]");
                        report.addUpToDateFile(destFile, artifact);
                    }
                    if ("ivy".equals(artifact.getType())) {
                        targetIvysStructure.addAll(FileUtil.getPathFiles(ivyRetrieveRoot, destFile));
                        continue;
                    }
                    targetArtifactsStructure.addAll(FileUtil.getPathFiles(fileRetrieveRoot, destFile));
                }
            }
            if (options.isSync()) {
                Collection existingIvys;
                Message.verbose("\tsyncing...");
                String[] ignorableFilenames = this.settings.getIgnorableFilenames();
                List<String> ignoreList = Arrays.asList(ignorableFilenames);
                Collection existingArtifacts = FileUtil.listAll(fileRetrieveRoot, ignoreList);
                Collection collection = existingIvys = ivyRetrieveRoot == null ? null : FileUtil.listAll(ivyRetrieveRoot, ignoreList);
                if (fileRetrieveRoot.equals(ivyRetrieveRoot)) {
                    HashSet target = targetArtifactsStructure;
                    target.addAll(targetIvysStructure);
                    Collection existing = existingArtifacts;
                    existing.addAll(existingIvys);
                    this.sync(target, existing);
                } else {
                    this.sync(targetArtifactsStructure, existingArtifacts);
                    if (existingIvys != null) {
                        this.sync(targetIvysStructure, existingIvys);
                    }
                }
            }
            long elapsedTime = System.currentTimeMillis() - start;
            String msg = "\t" + report.getNbrArtifactsCopied() + " artifacts copied" + (this.settings.isCheckUpToDate() ? ", " + report.getNbrArtifactsUpToDate() + " already retrieved" : "") + " (" + totalCopiedSize / 1024L + "kB/" + elapsedTime + "ms)";
            if ("default".equals(options.getLog())) {
                Message.info(msg);
            } else {
                Message.verbose(msg);
            }
            Message.verbose("\tretrieve done (" + elapsedTime + "ms)");
            if (this.eventManager != null) {
                this.eventManager.fireIvyEvent(new EndRetrieveEvent(mrid, confs, elapsedTime, report.getNbrArtifactsCopied(), report.getNbrArtifactsUpToDate(), totalCopiedSize, options));
            }
            return report;
        }
        catch (Exception ex) {
            throw new RuntimeException("problem during retrieve of " + moduleId + ": " + ex, ex);
        }
    }

    private String[] getConfs(ModuleRevisionId mrid, RetrieveOptions options) throws IOException {
        String[] confs = options.getConfs();
        if (confs == null || confs.length == 1 && "*".equals(confs[0])) {
            try {
                ModuleDescriptor md = this.getCache().getResolvedModuleDescriptor(mrid);
                Message.verbose("no explicit confs given for retrieve, using ivy file: " + md.getResource().getName());
                confs = md.getConfigurationsNames();
                options.setConfs(confs);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                IOException ioex = new IOException(e.getMessage());
                ioex.initCause(e);
                throw ioex;
            }
        }
        return confs;
    }

    private ResolutionCacheManager getCache() {
        return this.settings.getResolutionCacheManager();
    }

    private void sync(Collection target, Collection existing) {
        File file;
        HashSet<File> toRemove = new HashSet<File>();
        Iterator iter = existing.iterator();
        while (iter.hasNext()) {
            file = (File)iter.next();
            toRemove.add(file.getAbsoluteFile());
        }
        iter = target.iterator();
        while (iter.hasNext()) {
            file = (File)iter.next();
            toRemove.remove(file.getAbsoluteFile());
        }
        iter = toRemove.iterator();
        while (iter.hasNext()) {
            file = (File)iter.next();
            if (!file.exists()) continue;
            Message.verbose("\t\tdeleting " + file);
            FileUtil.forceDelete(file);
        }
    }

    public Map determineArtifactsToCopy(ModuleRevisionId mrid, String destFilePattern, RetrieveOptions options) throws ParseException, IOException {
        ModuleId moduleId = mrid.getModuleId();
        if (options.getResolveId() == null) {
            options.setResolveId(ResolveOptions.getDefaultResolveId(moduleId));
        }
        ResolutionCacheManager cacheManager = this.getCache();
        String[] confs = this.getConfs(mrid, options);
        String destIvyPattern = IvyPatternHelper.substituteVariables(options.getDestIvyPattern(), this.settings.getVariables());
        HashMap artifactsToCopy = new HashMap();
        HashMap conflictsMap = new HashMap();
        HashMap conflictsReportsMap = new HashMap();
        HashMap conflictsConfMap = new HashMap();
        XmlReportParser parser = new XmlReportParser();
        for (int i = 0; i < confs.length; ++i) {
            String conf = confs[i];
            File report = cacheManager.getConfigurationResolveReportInCache(options.getResolveId(), conf);
            parser.parse(report);
            ArrayList<ArtifactDownloadReport> artifacts = new ArrayList<ArtifactDownloadReport>(Arrays.asList(parser.getArtifactReports()));
            if (destIvyPattern != null) {
                ModuleRevisionId[] mrids = parser.getRealDependencyRevisionIds();
                for (int j = 0; j < mrids.length; ++j) {
                    artifacts.add(parser.getMetadataArtifactReport(mrids[j]));
                }
            }
            Iterator iter = artifacts.iterator();
            while (iter.hasNext()) {
                String destPattern;
                ArtifactDownloadReport artifact = (ArtifactDownloadReport)iter.next();
                String string = destPattern = "ivy".equals(artifact.getType()) ? destIvyPattern : destFilePattern;
                if (!"ivy".equals(artifact.getType()) && !options.getArtifactFilter().accept(artifact.getArtifact())) continue;
                String destFileName = IvyPatternHelper.substitute(destPattern, artifact.getArtifact().getModuleRevisionId(), artifact.getArtifact(), conf, artifact.getArtifactOrigin());
                HashSet<String> dest = (HashSet<String>)artifactsToCopy.get(artifact);
                if (dest == null) {
                    dest = new HashSet<String>();
                    artifactsToCopy.put(artifact, dest);
                }
                String copyDest = this.settings.resolveFile(destFileName).getAbsolutePath();
                String[] destinations = new String[]{copyDest};
                if (options.getMapper() != null) {
                    destinations = options.getMapper().mapFileName(copyDest);
                }
                for (int j = 0; j < destinations.length; ++j) {
                    dest.add(destinations[j]);
                    HashSet<ArtifactRevisionId> conflicts = (HashSet<ArtifactRevisionId>)conflictsMap.get(destinations[j]);
                    HashSet<ArtifactDownloadReport> conflictsReports = (HashSet<ArtifactDownloadReport>)conflictsReportsMap.get(destinations[j]);
                    HashSet<String> conflictsConf = (HashSet<String>)conflictsConfMap.get(destinations[j]);
                    if (conflicts == null) {
                        conflicts = new HashSet<ArtifactRevisionId>();
                        conflictsMap.put(destinations[j], conflicts);
                    }
                    if (conflictsReports == null) {
                        conflictsReports = new HashSet<ArtifactDownloadReport>();
                        conflictsReportsMap.put(destinations[j], conflictsReports);
                    }
                    if (conflictsConf == null) {
                        conflictsConf = new HashSet<String>();
                        conflictsConfMap.put(destinations[j], conflictsConf);
                    }
                    if (!conflicts.add(artifact.getArtifact().getId())) continue;
                    conflictsReports.add(artifact);
                    conflictsConf.add(conf);
                }
            }
        }
        Iterator iter = conflictsMap.keySet().iterator();
        while (iter.hasNext()) {
            int i;
            String copyDest = (String)iter.next();
            Set artifacts = (Set)conflictsMap.get(copyDest);
            Set conflictsConfs = (Set)conflictsConfMap.get(copyDest);
            if (artifacts.size() <= 1) continue;
            ArrayList artifactsList = new ArrayList((Collection)conflictsReportsMap.get(copyDest));
            Collections.sort(artifactsList, this.getConflictResolvingPolicy());
            ArtifactDownloadReport winner = (ArtifactDownloadReport)artifactsList.get(artifactsList.size() - 1);
            ModuleRevisionId winnerMD = winner.getArtifact().getModuleRevisionId();
            for (i = artifactsList.size() - 2; i >= 0; --i) {
                ArtifactDownloadReport current = (ArtifactDownloadReport)artifactsList.get(i);
                if (!winnerMD.equals(current.getArtifact().getModuleRevisionId())) continue;
                throw new RuntimeException("Multiple artifacts of the module " + winnerMD + " are retrieved to the same file! Update the retrieve pattern " + " to fix this error.");
            }
            Message.info("\tconflict on " + copyDest + " in " + conflictsConfs + ": " + winnerMD.getRevision() + " won");
            for (i = artifactsList.size() - 2; i >= 0; --i) {
                ArtifactDownloadReport looser = (ArtifactDownloadReport)artifactsList.get(i);
                Message.verbose("\t\tremoving conflict looser artifact: " + looser.getArtifact());
                Set dest = (Set)artifactsToCopy.get(looser);
                dest.remove(copyDest);
                if (!dest.isEmpty()) continue;
                artifactsToCopy.remove(looser);
            }
        }
        return artifactsToCopy;
    }

    private boolean upToDate(File source, File target, RetrieveOptions options) {
        if (!target.exists()) {
            return false;
        }
        String overwriteMode = options.getOverwriteMode();
        if ("always".equals(overwriteMode)) {
            return false;
        }
        if ("never".equals(overwriteMode)) {
            return true;
        }
        if ("newer".equals(overwriteMode)) {
            return source.lastModified() <= target.lastModified();
        }
        if ("different".equals(overwriteMode)) {
            return source.lastModified() == target.lastModified();
        }
        return false;
    }

    private Comparator getConflictResolvingPolicy() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                Artifact a1 = ((ArtifactDownloadReport)o1).getArtifact();
                Artifact a2 = ((ArtifactDownloadReport)o2).getArtifact();
                if (a1.getPublicationDate().after(a2.getPublicationDate())) {
                    return 1;
                }
                if (a1.getPublicationDate().before(a2.getPublicationDate())) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

