/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.osgi.core;

import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.Artifact;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.DefaultArtifact;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.BundleInfo;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.BundleInfoAdapter;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.ManifestParser;
import com.crashlytics.reloc.org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import com.crashlytics.reloc.org.apache.ivy.plugins.parser.ParserSettings;
import com.crashlytics.reloc.org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.Resource;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.url.URLResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.jar.Manifest;

public class OSGiManifestParser
implements ModuleDescriptorParser {
    private static final OSGiManifestParser INSTANCE = new OSGiManifestParser();
    private ExecutionEnvironmentProfileProvider profileProvider;

    public static OSGiManifestParser getInstance() {
        return INSTANCE;
    }

    public void add(ExecutionEnvironmentProfileProvider pp) {
        this.profileProvider = pp;
    }

    public boolean accept(Resource res) {
        if (res == null || res.getName() == null || res.getName().trim().equals("")) {
            return false;
        }
        return res.getName().toUpperCase(Locale.US).endsWith("MANIFEST.MF");
    }

    public ModuleDescriptor parseDescriptor(ParserSettings ivySettings, URL descriptorURL, Resource res, boolean validate) throws ParseException, IOException {
        Manifest m = new Manifest(res.openStream());
        BundleInfo bundleInfo = ManifestParser.parseManifest(m);
        try {
            bundleInfo.setUri(new URI(res.getName()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unsupported repository, resources names are not uris", e);
        }
        return BundleInfoAdapter.toModuleDescriptor(this, null, bundleInfo, this.profileProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toIvyFile(InputStream is, Resource res, File destFile, ModuleDescriptor md) throws ParseException, IOException {
        try {
            XmlModuleDescriptorWriter.write(md, destFile);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public ModuleDescriptor parseDescriptor(ParserSettings ivySettings, URL descriptorURL, boolean validate) throws ParseException, IOException {
        URLResource resource = new URLResource(descriptorURL);
        return this.parseDescriptor(ivySettings, descriptorURL, resource, validate);
    }

    public String getType() {
        return "manifest";
    }

    public Artifact getMetadataArtifact(ModuleRevisionId mrid, Resource res) {
        return DefaultArtifact.newIvyArtifact(mrid, new Date(res.getLastModified()));
    }

    public String toString() {
        return "manifest parser";
    }
}

