/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.osgi.obr.filter;

import com.crashlytics.reloc.org.apache.ivy.osgi.obr.filter.AndFilter;
import com.crashlytics.reloc.org.apache.ivy.osgi.obr.filter.CompareFilter;
import com.crashlytics.reloc.org.apache.ivy.osgi.obr.filter.MultiOperatorFilter;
import com.crashlytics.reloc.org.apache.ivy.osgi.obr.filter.NotFilter;
import com.crashlytics.reloc.org.apache.ivy.osgi.obr.filter.OrFilter;
import com.crashlytics.reloc.org.apache.ivy.osgi.obr.xml.RequirementFilter;
import java.text.ParseException;

public class RequirementFilterParser {
    public static RequirementFilter parse(String text) throws ParseException {
        return new Parser(text).parse();
    }

    static class Parser {
        private final String text;
        private int length;
        private int pos = 0;
        private char c;

        Parser(String text) {
            this.text = text;
            this.length = text.length();
        }

        RequirementFilter parse() throws ParseException {
            return this.parseFilter();
        }

        private char readNext() {
            this.c = this.pos == this.length ? (char)'\u0000' : this.text.charAt(this.pos++);
            return this.c;
        }

        private void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }

        private RequirementFilter parseFilter() throws ParseException {
            RequirementFilter filter;
            this.skipWhiteSpace();
            this.readNext();
            if (this.c != '(') {
                throw new ParseException("Expecting '(' as the start of the filter", this.pos);
            }
            switch (this.readNext()) {
                case '&': {
                    filter = this.parseAnd();
                    break;
                }
                case '|': {
                    filter = this.parseOr();
                    break;
                }
                case '!': {
                    filter = this.parseNot();
                    break;
                }
                default: {
                    this.unread();
                    filter = this.parseCompare();
                }
            }
            this.readNext();
            if (this.c != ')') {
                throw new ParseException("Expecting ')' as the end of the filter", this.pos);
            }
            return filter;
        }

        private RequirementFilter parseCompare() throws ParseException {
            String leftValue = this.parseCompareValue();
            CompareFilter.Operator operator = this.parseCompareOperator();
            String rightValue = this.parseCompareValue();
            return new CompareFilter(leftValue, operator, rightValue);
        }

        private String parseCompareValue() {
            StringBuffer builder = new StringBuffer();
            do {
                this.readNext();
                if (this.isOperator(this.c) || this.c == ')' || this.c == '(') {
                    this.unread();
                    break;
                }
                builder.append(this.c);
            } while (this.pos < this.length);
            return builder.toString();
        }

        private boolean isOperator(char ch) {
            return ch == '=' || ch == '<' || ch == '>';
        }

        private CompareFilter.Operator parseCompareOperator() throws ParseException {
            switch (this.readNext()) {
                case '=': {
                    return CompareFilter.Operator.EQUALS;
                }
                case '>': {
                    if (this.readNext() == '=') {
                        return CompareFilter.Operator.GREATER_OR_EQUAL;
                    }
                    this.unread();
                    return CompareFilter.Operator.GREATER_THAN;
                }
                case '<': {
                    if (this.readNext() == '=') {
                        return CompareFilter.Operator.LOWER_OR_EQUAL;
                    }
                    this.unread();
                    return CompareFilter.Operator.LOWER_THAN;
                }
            }
            throw new ParseException("Expecting an operator: =, <, <=, > or >=", this.pos);
        }

        private RequirementFilter parseAnd() throws ParseException {
            AndFilter filter = new AndFilter();
            this.parseMultiOperator(filter);
            return filter;
        }

        private RequirementFilter parseOr() throws ParseException {
            OrFilter filter = new OrFilter();
            this.parseMultiOperator(filter);
            return filter;
        }

        private void parseMultiOperator(MultiOperatorFilter filter) throws ParseException {
            do {
                this.skipWhiteSpace();
                this.readNext();
                if (this.c != '(') {
                    this.unread();
                    break;
                }
                this.unread();
                filter.add(this.parseFilter());
            } while (this.pos < this.length);
            if (filter.getSubFilters().size() == 0) {
                throw new ParseException("Expecting at least one sub filter", this.pos);
            }
        }

        private RequirementFilter parseNot() throws ParseException {
            this.readNext();
            if (this.c != '(') {
                throw new ParseException("The ! operator is expecting a filter", this.pos);
            }
            this.unread();
            return new NotFilter(this.parseFilter());
        }

        private void skipWhiteSpace() {
            do {
                switch (this.readNext()) {
                    case ' ': {
                        break;
                    }
                    default: {
                        this.unread();
                        return;
                    }
                }
            } while (this.pos < this.length);
        }
    }
}

