/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.osgi.repo;

import com.crashlytics.reloc.org.apache.ivy.osgi.repo.ManifestAndLocation;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;

public abstract class AbstractFSManifestIterable {
    private final Object root;

    public AbstractFSManifestIterable(Object root) {
        this.root = root;
    }

    public Iterator iterator() {
        return new FSManifestIterator(this.root);
    }

    protected abstract List listBundleFiles(Object var1) throws IOException;

    protected abstract List listDirs(Object var1) throws IOException;

    protected abstract InputStream getInputStream(Object var1) throws IOException;

    protected abstract URI buildBundleURI(Object var1) throws IOException;

    class FSManifestIterator
    implements Iterator {
        private ManifestAndLocation next = null;
        private Stack dirs = new Stack();
        private Iterator bundleCandidates = null;
        private Object currentDir = null;

        FSManifestIterator(Object root) {
            this.dirs.add(Collections.singleton(root).iterator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            while (this.next == null) {
                if (this.currentDir == null) {
                    if (((Iterator)this.dirs.peek()).hasNext()) {
                        this.currentDir = ((Iterator)this.dirs.peek()).next();
                        try {
                            this.bundleCandidates = AbstractFSManifestIterable.this.listBundleFiles(this.currentDir).iterator();
                        }
                        catch (IOException e) {
                            Message.warn("Unlistable dir: " + this.currentDir + " (" + e + ")");
                            this.currentDir = null;
                        }
                        continue;
                    }
                    if (this.dirs.size() <= 1) {
                        return false;
                    }
                    this.dirs.pop();
                    continue;
                }
                if (this.bundleCandidates.hasNext()) {
                    Object bundleCandidate = this.bundleCandidates.next();
                    ZipInputStream in = null;
                    try {
                        in = new JarInputStream(AbstractFSManifestIterable.this.getInputStream(bundleCandidate));
                        Manifest manifest = ((JarInputStream)in).getManifest();
                        if (manifest != null) {
                            this.next = new ManifestAndLocation(manifest, AbstractFSManifestIterable.this.buildBundleURI(bundleCandidate));
                            continue;
                        }
                        Message.debug("No manifest in jar: " + bundleCandidate);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        Message.debug("Jar file just removed: " + bundleCandidate + " (" + e + ")");
                        continue;
                    }
                    catch (IOException e) {
                        Message.warn("Unreadable jar: " + bundleCandidate + " (" + e + ")");
                        continue;
                    }
                    finally {
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                        continue;
                    }
                }
                try {
                    this.dirs.add(AbstractFSManifestIterable.this.listDirs(this.currentDir).iterator());
                }
                catch (IOException e) {
                    Message.warn("Unlistable dir: " + this.currentDir + " (" + e + ")");
                    this.dirs.add(Collections.EMPTY_LIST.iterator());
                }
                this.currentDir = null;
            }
            return true;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ManifestAndLocation manifest = this.next;
            this.next = null;
            return manifest;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

