/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.osgi.updatesite;

import com.crashlytics.reloc.org.apache.ivy.osgi.core.BundleInfo;
import com.crashlytics.reloc.org.apache.ivy.osgi.core.BundleRequirement;
import com.crashlytics.reloc.org.apache.ivy.osgi.updatesite.xml.EclipseFeature;
import com.crashlytics.reloc.org.apache.ivy.osgi.updatesite.xml.EclipsePlugin;
import com.crashlytics.reloc.org.apache.ivy.osgi.updatesite.xml.Require;
import com.crashlytics.reloc.org.apache.ivy.osgi.util.VersionRange;
import java.net.URI;
import java.util.Iterator;

public class PluginAdapter {
    public static BundleInfo featureAsBundle(URI baseUri, EclipseFeature feature) {
        BundleInfo b = new BundleInfo(feature.getId(), feature.getVersion());
        if (feature.getUrl() == null) {
            b.setUri(baseUri.resolve("features/" + feature.getId() + '_' + feature.getVersion() + ".jar"));
        } else {
            b.setUri(baseUri.resolve(feature.getUrl()));
        }
        b.setDescription(feature.getDescription());
        b.setLicense(feature.getLicense());
        Iterator itPlugins = feature.getPlugins().iterator();
        while (itPlugins.hasNext()) {
            EclipsePlugin plugin = (EclipsePlugin)itPlugins.next();
            BundleRequirement r = new BundleRequirement("bundle", plugin.getId(), new VersionRange(plugin.getVersion()), null);
            b.addRequirement(r);
        }
        Iterator itRequires = feature.getRequires().iterator();
        while (itRequires.hasNext()) {
            Require require = (Require)itRequires.next();
            String id = require.getPlugin() != null ? require.getPlugin() : require.getFeature();
            if (!require.getMatch().equals("greaterOrEqual")) {
                throw new IllegalStateException("unsupported match " + require.getMatch());
            }
            VersionRange range = new VersionRange(require.getVersion());
            BundleRequirement r = new BundleRequirement("bundle", id, range, null);
            b.addRequirement(r);
        }
        return b;
    }

    public static BundleInfo pluginAsBundle(URI baseUri, EclipsePlugin plugin) {
        BundleInfo b = new BundleInfo(plugin.getId(), plugin.getVersion());
        b.setUri(baseUri.resolve("plugins/" + plugin.getId() + '_' + plugin.getVersion() + ".jar"));
        return b;
    }
}

