/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.plugins.conflict;

import com.crashlytics.reloc.org.apache.ivy.core.resolve.IvyNode;
import com.crashlytics.reloc.org.apache.ivy.plugins.conflict.AbstractConflictManager;
import com.crashlytics.reloc.org.apache.ivy.plugins.conflict.StrictConflictException;
import com.crashlytics.reloc.org.apache.ivy.plugins.version.VersionMatcher;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class StrictConflictManager
extends AbstractConflictManager {
    public Collection resolveConflicts(IvyNode parent, Collection conflicts) {
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        IvyNode lastNode = null;
        Iterator iter = conflicts.iterator();
        while (iter.hasNext()) {
            IvyNode node = (IvyNode)iter.next();
            if (versionMatcher.isDynamic(node.getResolvedId())) {
                return null;
            }
            if (lastNode != null && !lastNode.equals(node)) {
                throw new StrictConflictException(lastNode, node);
            }
            lastNode = node;
        }
        return Collections.singleton(lastNode);
    }
}

