/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.plugins.matcher;

import com.crashlytics.reloc.org.apache.ivy.plugins.matcher.Matcher;
import com.crashlytics.reloc.org.apache.ivy.plugins.matcher.PatternMatcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapMatcher {
    private Map matchers = new HashMap();
    private PatternMatcher pm;
    private Map attributes;

    public MapMatcher(Map attributes, PatternMatcher pm) {
        this.attributes = attributes;
        this.pm = pm;
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String value = (String)entry.getValue();
            if (value == null) continue;
            this.matchers.put(entry.getKey(), pm.getMatcher(value));
        }
    }

    public boolean matches(Map m) {
        Iterator iter = this.matchers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Matcher matcher = (Matcher)entry.getValue();
            String value = (String)m.get(entry.getKey());
            if (value != null && matcher.matches(value)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.attributes + " (" + this.pm.getName() + ")";
    }

    public Map getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public PatternMatcher getPatternMatcher() {
        return this.pm;
    }
}

