/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.plugins.repository;

import com.crashlytics.reloc.org.apache.ivy.plugins.repository.Resource;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.file.FileResource;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.url.URLResource;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import java.io.File;
import java.net.MalformedURLException;

public final class ResourceHelper {
    private ResourceHelper() {
    }

    public static boolean equals(Resource res, File f) {
        if (res == null && f == null) {
            return true;
        }
        if (res == null || f == null) {
            return false;
        }
        if (res instanceof FileResource) {
            return new File(res.getName()).equals(f);
        }
        if (res instanceof URLResource) {
            try {
                return f.toURI().toURL().toExternalForm().equals(res.getName());
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }

    public static long getLastModifiedOrDefault(Resource res) {
        long last = res.getLastModified();
        if (last > 0L) {
            return last;
        }
        Message.debug("impossible to get date for " + res + ": using 'now'");
        return System.currentTimeMillis();
    }
}

