/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.plugins.resolver;

import com.crashlytics.reloc.org.apache.ivy.core.cache.CacheResourceOptions;
import com.crashlytics.reloc.org.apache.ivy.core.event.EventManager;
import com.crashlytics.reloc.org.apache.ivy.core.report.ArtifactDownloadReport;
import com.crashlytics.reloc.org.apache.ivy.core.report.DownloadStatus;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.jar.JarRepository;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.url.URLRepository;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.url.URLResource;
import com.crashlytics.reloc.org.apache.ivy.plugins.resolver.RepositoryResolver;
import com.crashlytics.reloc.org.apache.ivy.plugins.resolver.ResolverSettings;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;

public class JarResolver
extends RepositoryResolver {
    private URL url;

    public JarResolver() {
        this.setRepository(new JarRepository());
    }

    public String getTypeName() {
        return "jar";
    }

    public void setFile(String jarFile) {
        this.setJarFile(new File(jarFile));
    }

    public void setUrl(String jarUrl) {
        try {
            this.url = new URL(jarUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("the jar repository " + this.getName() + " has an malformed url : " + jarUrl + " (" + e.getMessage() + ")");
        }
    }

    public JarRepository getJarRepository() {
        return (JarRepository)super.getRepository();
    }

    private void setJarFile(File jarLocalFile) {
        JarFile jar;
        try {
            jar = new JarFile(jarLocalFile);
        }
        catch (IOException e) {
            throw new RuntimeException("the jar repository " + this.getName() + " could not be read (" + e.getMessage() + ")", e);
        }
        this.getJarRepository().setJarFile(jar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettings(ResolverSettings settings) {
        super.setSettings(settings);
        if (this.url != null) {
            ArtifactDownloadReport report;
            EventManager eventManager = this.getEventManager();
            try {
                if (eventManager != null) {
                    this.getRepository().addTransferListener(eventManager);
                }
                URLResource jarResource = new URLResource(this.url);
                CacheResourceOptions options = new CacheResourceOptions();
                report = this.getRepositoryCacheManager().downloadRepositoryResource(jarResource, "jarrepository", "jar", "jar", options, new URLRepository());
            }
            finally {
                if (eventManager != null) {
                    this.getRepository().removeTransferListener(eventManager);
                }
            }
            if (report.getDownloadStatus() == DownloadStatus.FAILED) {
                throw new RuntimeException("The jar file " + this.url.toExternalForm() + " could not be downloaded (" + report.getDownloadDetails() + ")");
            }
            this.setJarFile(report.getLocalFile());
        }
    }
}

