/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.plugins.resolver.packager;

import com.crashlytics.reloc.org.apache.ivy.core.IvyPatternHelper;
import com.crashlytics.reloc.org.apache.ivy.core.module.descriptor.Artifact;
import com.crashlytics.reloc.org.apache.ivy.core.module.id.ModuleRevisionId;
import com.crashlytics.reloc.org.apache.ivy.plugins.repository.Resource;
import com.crashlytics.reloc.org.apache.ivy.plugins.resolver.packager.BuiltFileResource;
import com.crashlytics.reloc.org.apache.ivy.plugins.resolver.util.ResolvedResource;
import com.crashlytics.reloc.org.apache.ivy.util.FileUtil;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import com.crashlytics.reloc.org.apache.tools.ant.BuildException;
import com.crashlytics.reloc.org.apache.tools.ant.BuildListener;
import com.crashlytics.reloc.org.apache.tools.ant.DefaultLogger;
import com.crashlytics.reloc.org.apache.tools.ant.Project;
import com.crashlytics.reloc.org.apache.tools.ant.ProjectHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;

public class PackagerCacheEntry {
    private final ModuleRevisionId mr;
    private final File dir;
    private final File resourceCache;
    private final String resourceURL;
    private final boolean validate;
    private final boolean preserve;
    private final boolean restricted;
    private final boolean verbose;
    private final boolean quiet;
    private boolean built;

    public PackagerCacheEntry(ModuleRevisionId mr, File rootDir, File resourceCache, String resourceURL, boolean validate, boolean preserve, boolean restricted, boolean verbose, boolean quiet) {
        this.mr = mr;
        this.dir = PackagerCacheEntry.getSubdir(rootDir, this.mr);
        this.resourceCache = resourceCache;
        this.resourceURL = resourceURL;
        this.validate = validate;
        this.preserve = preserve;
        this.restricted = restricted;
        this.verbose = verbose;
        this.quiet = quiet;
    }

    public synchronized void build(Resource packagerResource, Map properties) throws IOException {
        if (this.built) {
            throw new IllegalStateException("build in directory `" + this.dir + "' already completed");
        }
        if (this.dir.exists() && !this.cleanup()) {
            throw new IOException("can't remove directory `" + this.dir + "'");
        }
        if (!this.dir.mkdirs()) {
            throw new IOException("can't create directory `" + this.dir + "'");
        }
        InputStream packagerXML = packagerResource.openStream();
        this.saveFile("packager.xml", packagerXML);
        this.saveFile("packager.xsl");
        this.saveFile("packager-1.0.xsd");
        this.saveFile("build.xml");
        Project project = new Project();
        project.init();
        project.setUserProperty("ant.file", new File(this.dir, "build.xml").getAbsolutePath());
        ProjectHelper.configureProject((Project)project, (File)new File(this.dir, "build.xml"));
        project.setBaseDir(this.dir);
        DefaultLogger logger = new DefaultLogger();
        logger.setMessageOutputLevel(this.verbose ? 3 : (this.quiet ? 1 : 2));
        logger.setOutputPrintStream(System.out);
        logger.setErrorPrintStream(System.err);
        project.addBuildListener((BuildListener)logger);
        project.setUserProperty("ivy.packager.organisation", "" + this.mr.getModuleId().getOrganisation());
        project.setUserProperty("ivy.packager.module", "" + this.mr.getModuleId().getName());
        project.setUserProperty("ivy.packager.revision", "" + this.mr.getRevision());
        project.setUserProperty("ivy.packager.branch", "" + this.mr.getBranch());
        if (this.resourceCache != null) {
            project.setUserProperty("ivy.packager.resourceCache", "" + this.resourceCache.getCanonicalPath());
        }
        if (this.resourceURL != null) {
            project.setUserProperty("ivy.packager.resourceURL", "" + this.getResourceURL());
        }
        if (this.validate) {
            project.setUserProperty("ivy.packager.validate", "true");
        }
        project.setUserProperty("ivy.packager.restricted", "" + this.restricted);
        project.setUserProperty("ivy.packager.quiet", String.valueOf(this.quiet));
        if (properties != null) {
            Iterator it = properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                project.setUserProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        Message.verbose("performing packager resolver build in " + this.dir);
        try {
            project.executeTarget("build");
            this.built = true;
        }
        catch (BuildException e) {
            e.printStackTrace(System.out);
            Message.verbose("packager resolver build failed: " + (Object)((Object)e));
            throw e;
        }
    }

    public synchronized boolean isBuilt() {
        return this.built;
    }

    public ResolvedResource getBuiltArtifact(Artifact artifact) {
        if (!this.built) {
            throw new IllegalStateException("build in directory `" + this.dir + "' has not yet successfully completed");
        }
        return new ResolvedResource(new BuiltFileResource(this.dir, artifact), this.mr.getRevision());
    }

    public synchronized boolean cleanup() {
        this.built = false;
        return FileUtil.forceDelete(this.dir);
    }

    protected void saveFile(String name, InputStream input) throws IOException {
        FileUtil.copy(input, new File(this.dir, name), null);
    }

    protected void saveFile(String name) throws IOException {
        InputStream input = this.getClass().getResourceAsStream(name);
        if (input == null) {
            throw new IOException("can't find resource `" + name + "'");
        }
        this.saveFile(name, input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.preserve) {
                this.cleanup();
            }
        }
        finally {
            super.finalize();
        }
    }

    private String getResourceURL() {
        String baseURL = IvyPatternHelper.substitute(this.resourceURL, this.mr.getOrganisation(), this.mr.getName(), this.mr.getRevision(), null, null, null, null, this.mr.getQualifiedExtraAttributes(), null);
        int slash = baseURL.lastIndexOf(47);
        if (slash != -1) {
            baseURL = baseURL.substring(0, slash + 1);
        }
        return baseURL;
    }

    private static File getSubdir(File rootDir, ModuleRevisionId mr) {
        return new File(rootDir, mr.getOrganisation() + File.separatorChar + mr.getName() + File.separatorChar + mr.getRevision());
    }
}

