/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.reloc.org.apache.ivy.util;

import com.crashlytics.reloc.org.apache.ivy.util.Checks;
import com.crashlytics.reloc.org.apache.ivy.util.Message;
import com.crashlytics.reloc.org.apache.ivy.util.MessageLogger;
import com.crashlytics.reloc.org.apache.ivy.util.MessageLoggerHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class MessageLoggerEngine
implements MessageLogger {
    private final Stack loggerStack = new Stack();
    private MessageLogger defaultLogger = null;
    private List problems = new ArrayList();
    private List warns = new ArrayList();
    private List errors = new ArrayList();

    public void setDefaultLogger(MessageLogger defaultLogger) {
        this.defaultLogger = defaultLogger;
    }

    public void pushLogger(MessageLogger logger) {
        Checks.checkNotNull(logger, "logger");
        this.loggerStack.push(logger);
    }

    public void popLogger() {
        if (!this.loggerStack.isEmpty()) {
            this.loggerStack.pop();
        }
    }

    public MessageLogger peekLogger() {
        if (this.loggerStack.isEmpty()) {
            return this.getDefaultLogger();
        }
        return (MessageLogger)this.loggerStack.peek();
    }

    private MessageLogger getDefaultLogger() {
        return this.defaultLogger == null ? Message.getDefaultLogger() : this.defaultLogger;
    }

    public void warn(String msg) {
        this.peekLogger().warn(msg);
        this.problems.add("WARN:  " + msg);
        this.warns.add(msg);
    }

    public void error(String msg) {
        this.peekLogger().error(msg);
        this.problems.add("\tERROR: " + msg);
        this.errors.add(msg);
    }

    public List getErrors() {
        return this.errors;
    }

    public List getProblems() {
        return this.problems;
    }

    public List getWarns() {
        return this.warns;
    }

    public void sumupProblems() {
        MessageLoggerHelper.sumupProblems(this);
        this.clearProblems();
    }

    public void clearProblems() {
        this.getDefaultLogger().clearProblems();
        Iterator iter = this.loggerStack.iterator();
        while (iter.hasNext()) {
            MessageLogger l = (MessageLogger)iter.next();
            l.clearProblems();
        }
        this.problems.clear();
        this.errors.clear();
        this.warns.clear();
    }

    public void setShowProgress(boolean progress) {
        this.getDefaultLogger().setShowProgress(progress);
        Iterator iter = this.loggerStack.iterator();
        while (iter.hasNext()) {
            MessageLogger l = (MessageLogger)iter.next();
            l.setShowProgress(progress);
        }
    }

    public boolean isShowProgress() {
        return this.getDefaultLogger().isShowProgress();
    }

    public void debug(String msg) {
        this.peekLogger().debug(msg);
    }

    public void deprecated(String msg) {
        this.peekLogger().deprecated(msg);
    }

    public void endProgress() {
        this.peekLogger().endProgress();
    }

    public void endProgress(String msg) {
        this.peekLogger().endProgress(msg);
    }

    public void info(String msg) {
        this.peekLogger().info(msg);
    }

    public void rawinfo(String msg) {
        this.peekLogger().rawinfo(msg);
    }

    public void log(String msg, int level) {
        this.peekLogger().log(msg, level);
    }

    public void progress() {
        this.peekLogger().progress();
    }

    public void rawlog(String msg, int level) {
        this.peekLogger().rawlog(msg, level);
    }

    public void verbose(String msg) {
        this.peekLogger().verbose(msg);
    }
}

