/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.onboard;

import com.crashlytics.reloc.com.google.common.base.Joiner;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.onboard.CodeChange;
import com.crashlytics.tools.android.onboard.StubCode;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;

public class TwitterSyndicationCodeBlockFactory {
    public static String getViewXML(String indent) {
        Joiner joiner = Joiner.on(indent);
        return joiner.join("        <ScrollView xmlns:android=\"http://schemas.android.com/apk/res/android\"", "xmlns:twittersdk=\"http://schemas.android.com/apk/res-auto\"", "android:layout_width=\"match_parent\"", "android:layout_height=\"match_parent\">", "    <LinearLayout", "    android:layout_width=\"match_parent\"", "    android:layout_height=\"wrap_content\"", "    android:orientation=\"vertical\">", "", "    <com.twitter.sdk.android.tweetui.TweetView", "    android:id=\"@+id/photo_default_tweet\"", "    android:layout_width=\"match_parent\"", "    android:layout_height=\"wrap_content\"", "    twittersdk:tw__tweet_id=\"20\"/>", "", "    </LinearLayout>", "</ScrollView>");
    }

    private static String createImports(Collection<? extends String> imports) {
        StringBuilder builder = new StringBuilder();
        for (String string : imports) {
            builder.append("import ");
            builder.append(string);
            builder.append(";\n");
        }
        return builder.toString();
    }

    private static CodeChange.BlockChange injectAfter(String searched, String contents, String toAdd) {
        int offset = contents.indexOf(searched);
        if (offset == -1) {
            DeveloperTools.logW("Could not find " + searched + " to add: " + toAdd, new IOException("Crashlytics failed to find item"));
            return new CodeChange.Insertion(0, toAdd);
        }
        return new CodeChange.Insertion(offset + searched.length() + 1, toAdd);
    }

    public static CodeChange getManualLayoutDirections(String viewFileContents) {
        String layoutElementcontent = "android:layout_height=\"wrap_content\" />";
        return new CodeChange("View XML", new StubCode(viewFileContents), Collections.singletonList(TwitterSyndicationCodeBlockFactory.injectAfter(layoutElementcontent, viewFileContents, TwitterSyndicationCodeBlockFactory.getViewXML("\n        "))));
    }
}

