/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.codemapping.csym;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class CSym {
    private final List<Range> _ranges;
    private final List<String> _files;
    private final List<String> _symbols;
    private final String _uuid;
    private final String _type;
    private final String _architecture;

    private CSym(Builder builder) {
        ArrayList ranges = new ArrayList(builder._ranges);
        Collections.sort(ranges);
        this._ranges = Collections.unmodifiableList(ranges);
        HashSet<String> fileSet = new HashSet<String>();
        HashSet<String> symbolSet = new HashSet<String>();
        for (Range range : this._ranges) {
            if (range.file != null) {
                fileSet.add(range.file);
            }
            if (range.symbol == null) continue;
            symbolSet.add(range.symbol);
        }
        this._files = Collections.unmodifiableList(new ArrayList(fileSet));
        this._symbols = Collections.unmodifiableList(new ArrayList(symbolSet));
        this._uuid = builder._uuid;
        this._type = builder._type;
        this._architecture = builder._architecture;
    }

    public String getArchitecture() {
        return this._architecture;
    }

    public String getUUID() {
        return this._uuid;
    }

    public String getType() {
        return this._type;
    }

    public List<String> getFiles() {
        return this._files;
    }

    public List<String> getSymbols() {
        return this._symbols;
    }

    public List<Range> getRanges() {
        return this._ranges;
    }

    public static final class Builder {
        private final List<Range> _ranges = new LinkedList<Range>();
        private final String _uuid;
        private final String _type;
        private final String _architecture;

        public Builder(String uuid, String type, String architecture) {
            this._uuid = uuid;
            this._type = type;
            this._architecture = architecture;
        }

        public Builder addRange(long offset, long size, String symbol) {
            this._ranges.add(new Range(offset, size, symbol));
            return this;
        }

        public Builder addRange(long offset, long size, String symbol, String file) {
            this._ranges.add(new Range(offset, size, symbol, file));
            return this;
        }

        public Builder addRange(long offset, long size, String symbol, String file, long lineNumber) {
            this._ranges.add(new Range(offset, size, symbol, file, lineNumber));
            return this;
        }

        public CSym build() {
            return new CSym(this);
        }
    }

    public static final class Range
    implements Comparable<Range> {
        public final long offset;
        public final long size;
        public final String symbol;
        public final String file;
        public final long lineNumber;

        public Range(long offset, long size, String symbol, String file, long lineNumber) {
            this.offset = offset;
            this.size = size;
            this.symbol = symbol;
            this.file = file;
            this.lineNumber = lineNumber;
        }

        public Range(long offset, long size, String symbol, String file) {
            this(offset, size, symbol, file, -1L);
        }

        public Range(long offset, long size, String symbol) {
            this(offset, size, symbol, null, -1L);
        }

        @Override
        public int compareTo(Range other) {
            return (int)(this.offset - other.offset);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            if (this.lineNumber != range.lineNumber) {
                return false;
            }
            if (this.offset != range.offset) {
                return false;
            }
            if (this.size != range.size) {
                return false;
            }
            if (this.file != null ? !this.file.equals(range.file) : range.file != null) {
                return false;
            }
            return !(this.symbol != null ? !this.symbol.equals(range.symbol) : range.symbol != null);
        }

        public int hashCode() {
            int result = (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + (int)(this.size ^ this.size >>> 32);
            result = 31 * result + (this.symbol != null ? this.symbol.hashCode() : 0);
            result = 31 * result + (this.file != null ? this.file.hashCode() : 0);
            result = 31 * result + (int)(this.lineNumber ^ this.lineNumber >>> 32);
            return result;
        }
    }
}

