/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.android.project.codemapping.csym;

import com.crashlytics.reloc.com.google.common.base.Optional;
import com.crashlytics.reloc.org.apache.commons.io.FileUtils;
import com.crashlytics.reloc.org.apache.commons.io.FilenameUtils;
import com.crashlytics.reloc.org.apache.commons.io.IOCase;
import com.crashlytics.reloc.org.apache.commons.io.filefilter.FileFilterUtils;
import com.crashlytics.reloc.org.apache.commons.io.filefilter.IOFileFilter;
import com.crashlytics.reloc.org.apache.commons.io.filefilter.TrueFileFilter;
import com.crashlytics.tools.android.DeveloperTools;
import com.crashlytics.tools.android.project.AndroidProject;
import com.crashlytics.tools.android.project.ManifestData;
import com.crashlytics.tools.android.project.codemapping.CodeMappingManager;
import com.crashlytics.tools.android.project.codemapping.CodeMappingMetadata;
import com.crashlytics.tools.android.project.codemapping.CodeMappingUploader;
import com.crashlytics.tools.android.project.codemapping.csym.CSym;
import com.crashlytics.tools.android.project.codemapping.csym.CSymFileWriter;
import com.crashlytics.tools.android.project.codemapping.csym.CSymGenerator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;

public class CSymFileManager
implements CodeMappingManager {
    private static final String CRASHLYTICS_FAILED_CSYM_UPLOAD_REASON = "had a problem uploading all cSYM files. Please check network connectivity and try again.";
    private static final String CRASHLYTICS_HALTED_COMPILATION = "Crashlytics halted compilation because it had a problem uploading all cSYM files. Please check network connectivity and try again.";
    private static final String CSYM_TYPE = "csym";
    private static final String LIB_PREFIX = "lib";
    private static final String SO_FILE_SUFFIX = ".so";
    private static final String METADATA_FILE_SUFFIX = ".meta";
    private static IOFileFilter SO_FILE_FILTER = FileFilterUtils.suffixFileFilter(".so", IOCase.INSENSITIVE);
    private final AndroidProject _project;
    private final CSymGenerator _cSymGenerator;
    private final CSymFileWriter _cSymFileWriter;
    private final CodeMappingUploader _uploader;
    private final File _cacheDir;
    private final File _archiveDir;

    public CSymFileManager(File cacheDir, File archiveDir, AndroidProject project, CSymGenerator cSymGenerator, CSymFileWriter cSymFileWriter, CodeMappingUploader uploader) {
        this._project = project;
        this._cSymGenerator = cSymGenerator;
        this._cSymFileWriter = cSymFileWriter;
        this._uploader = uploader;
        this._cacheDir = cacheDir;
        this._archiveDir = archiveDir;
    }

    @Override
    public void cacheCodeMappings() throws IOException {
        com.crashlytics.tools.utils.FileUtils.verifyDirectory(this._cacheDir);
        File soDir = this._project.getNdkOutDir();
        if (!soDir.isDirectory()) {
            throw new DeveloperTools.PluginException("Could not find NDK output path: " + soDir);
        }
        Collection<File> soFiles = FileUtils.listFiles(soDir, SO_FILE_FILTER, TrueFileFilter.INSTANCE);
        DeveloperTools.logD("Crashlytics generating cSYM files from object files in " + soDir);
        for (File soFile : soFiles) {
            CSym cSym = this._cSymGenerator.generateCSymFromFile(soFile);
            String filename = this._cSymFileWriter.getOutputFilename(cSym, this.getModuleName(soFile));
            File cSymFile = this._cSymFileWriter.writeCSymFile(cSym, filename);
            String mdFileName = this.getMetadataFileName(cSymFile);
            this.saveMetadata(this.createMetadata(cSym), new File(this._cacheDir, mdFileName));
        }
    }

    @Override
    public void uploadCachedCodeMappings(String apiKey, boolean requireSuccess) throws IOException {
        DeveloperTools.logD("Crashlytics attempting to upload cSYM files.");
        List<File> codeMappingFiles = this._cSymFileWriter.getCSymFiles();
        if (codeMappingFiles.isEmpty()) {
            DeveloperTools.logD("Crashlytics found no cSYM files.");
            return;
        }
        boolean uploadSuccess = false;
        Exception uploadException = null;
        try {
            uploadSuccess = this.uploadAndArchiveFiles(codeMappingFiles, apiKey);
        }
        catch (Exception e) {
            uploadException = e;
        }
        if (uploadSuccess) {
            DeveloperTools.logD("cSYM file(s) uploaded.");
        } else {
            DeveloperTools.logW("Crashlytics had a problem uploading all cSYM files. Please check network connectivity and try again.", uploadException);
            if (requireSuccess) {
                throw new DeveloperTools.PluginException(CRASHLYTICS_HALTED_COMPILATION, uploadException);
            }
        }
    }

    private boolean uploadAndArchiveFiles(List<File> codeMappingFiles, String apiKey) throws IOException {
        int sentFiles = 0;
        for (File cmFile : codeMappingFiles) {
            File metadataFile;
            CodeMappingMetadata md;
            boolean uploadSuccessful = this._uploader.uploadCodeMappingFile(cmFile, (md = this.loadMetadata(metadataFile = this.getMetadataFile(cmFile))).asParameterMap(), apiKey);
            if (!uploadSuccessful) continue;
            this.archiveCodeMapping(cmFile, metadataFile);
            ++sentFiles;
        }
        return sentFiles == codeMappingFiles.size();
    }

    private void archiveCodeMapping(File codeMappingFile, File metadataFile) throws IOException {
        boolean codeMappingMoved;
        com.crashlytics.tools.utils.FileUtils.verifyDirectory(this._archiveDir);
        boolean metadataMoved = metadataFile.renameTo(new File(this._archiveDir, metadataFile.getName()));
        if (!metadataMoved) {
            metadataFile.delete();
        }
        if (!(codeMappingMoved = codeMappingFile.renameTo(new File(this._archiveDir, codeMappingFile.getName())))) {
            codeMappingFile.delete();
        }
    }

    private CodeMappingMetadata createMetadata(CSym cSym) {
        ManifestData manifestData = this._project.getManifestData();
        String projectIdentifier = manifestData.getPackageName();
        String projectDisplayVersion = manifestData.getVersionName();
        int projectBuildVersion = 0;
        Optional<Integer> manifestVersionCode = manifestData.getVersionCode();
        if (!manifestVersionCode.isPresent()) {
            DeveloperTools.logD("Crashlytics did not find a version code and is interpreting it to be 0 by default");
        } else {
            projectBuildVersion = manifestVersionCode.get();
        }
        CodeMappingMetadata.Builder builder = new CodeMappingMetadata.Builder(projectIdentifier, projectBuildVersion, projectDisplayVersion, CSYM_TYPE);
        builder.addExecutable(cSym.getUUID(), cSym.getArchitecture());
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMetadata(CodeMappingMetadata md, File outputFile) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(outputFile));
            CodeMappingMetadata.serializeToJSON(md, writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodeMappingMetadata loadMetadata(File inputFile) throws IOException {
        CodeMappingMetadata md = null;
        BufferedReader mdReader = null;
        try {
            mdReader = new BufferedReader(new FileReader(inputFile));
            md = CodeMappingMetadata.parseFromJSON(mdReader);
        }
        finally {
            if (mdReader != null) {
                mdReader.close();
            }
        }
        return md;
    }

    private String getModuleName(File binFile) {
        String fileName = FilenameUtils.removeExtension(binFile.getName());
        if (fileName.startsWith(LIB_PREFIX)) {
            fileName = fileName.substring(LIB_PREFIX.length());
        }
        return fileName;
    }

    private File getMetadataFile(File codeMappingFile) {
        return new File(codeMappingFile.getParent(), this.getMetadataFileName(codeMappingFile));
    }

    private String getMetadataFileName(File codeMappingFile) {
        String filename = codeMappingFile.getName();
        return FilenameUtils.removeExtension(filename) + METADATA_FILE_SUFFIX;
    }
}

