/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils;

import com.crashlytics.tools.utils.Graph;
import com.crashlytics.tools.utils.SparseDirectedGraph;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class GraphUtils {
    public static <T> List<T> topologicalSort(Graph<T> dependencyGraph) throws GraphCycleException {
        SparseDirectedGraph<T> graphLeft = new SparseDirectedGraph<T>(dependencyGraph);
        LinkedList<T> currentLibraries = new LinkedList<T>();
        HashSet possibleLibraries = new HashSet();
        for (Object lib : dependencyGraph) {
            possibleLibraries.add(lib);
            if (!graphLeft.getNeighbors(lib).isEmpty()) continue;
            currentLibraries.add(lib);
            graphLeft.remove(lib);
        }
        LinkedList sortedLibraries = new LinkedList();
        while (!currentLibraries.isEmpty() && sortedLibraries.size() <= dependencyGraph.size()) {
            Object currentProcessed = currentLibraries.pop();
            Iterator<T> iter = graphLeft.iterator();
            while (iter.hasNext()) {
                T possibleParent = iter.next();
                Set<T> dependencies = graphLeft.getNeighbors(possibleParent);
                if (dependencies.contains(currentProcessed)) {
                    dependencies.remove(currentProcessed);
                }
                if (!dependencies.isEmpty()) continue;
                currentLibraries.add(possibleParent);
                iter.remove();
            }
            sortedLibraries.add(currentProcessed);
        }
        if (sortedLibraries.size() != dependencyGraph.size()) {
            throw new GraphCycleException("Sorted Library size greater than the dependency graph, Libraries contain a cycle? " + sortedLibraries + " with graph: " + dependencyGraph + " and left: " + graphLeft);
        }
        return Collections.unmodifiableList(sortedLibraries);
    }

    public static class GraphCycleException
    extends Exception {
        public GraphCycleException(String message) {
            super(message);
        }
    }
}

