/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.tools.utils.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class ElementOffsetFinder
extends DefaultHandler {
    private Locator _startOffset = null;
    private boolean _foundStart = false;
    private Locator _endOffset = null;
    private boolean _foundEnd = false;
    private Locator _locator;
    private final String _elementQName;
    private Map<String, String> _attributeMatchTemplate;

    public ElementOffsetFinder(String elementQName, Map<String, String> attributeMatchTemplate) {
        this._elementQName = elementQName;
        this._attributeMatchTemplate = attributeMatchTemplate;
    }

    public ElementOffsetFinder(String elementQName) {
        this._elementQName = elementQName;
        this._attributeMatchTemplate = Collections.emptyMap();
    }

    public Locator getEndOffsetLocator() {
        return this._endOffset;
    }

    public Locator getStartOffsetLocator() {
        return this._startOffset;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this._locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        if (!this._foundStart) {
            if (qName.equals(this._elementQName)) {
                this._foundStart = true;
                for (Map.Entry<String, String> attribute : this._attributeMatchTemplate.entrySet()) {
                    String value;
                    int index = attributes.getIndex(attribute.getKey());
                    if (index <= -1 || (value = attribute.getValue()) != null && value.equals(attributes.getValue(index))) continue;
                    this._foundStart = false;
                }
            } else {
                this._startOffset = new LocatorImpl(this._locator);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (this._foundStart && !this._foundEnd) {
            if (qName.equals(this._elementQName)) {
                this._foundEnd = true;
            } else {
                this._endOffset = new LocatorImpl(this._locator);
            }
        }
    }

    public static ElementOffsetFinder getElementOffset(InputStream xmlStream, String elementTag) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        ElementOffsetFinder handler = new ElementOffsetFinder(elementTag);
        parser.parse(xmlStream, (DefaultHandler)handler);
        return handler;
    }

    public static ElementOffsetFinder getElementOffset(InputStream xmlStream, String elementTag, Map<String, String> attributes) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        ElementOffsetFinder handler = new ElementOffsetFinder(elementTag, attributes);
        parser.parse(xmlStream, (DefaultHandler)handler);
        return handler;
    }
}

