/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileObject;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystem;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemOptions;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractFileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.FileProvider;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.LayeredFileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.LayeredFileNameParser;

public abstract class AbstractLayeredFileProvider
extends AbstractFileProvider
implements FileProvider {
    public AbstractLayeredFileProvider() {
        this.setFileNameParser(LayeredFileNameParser.getInstance());
    }

    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions properties) throws FileSystemException {
        LayeredFileName name = (LayeredFileName)this.parseUri(baseFile != null ? baseFile.getName() : null, uri);
        FileName fileName = name.getOuterName();
        FileObject file = this.getContext().resolveFile(baseFile, fileName.getURI(), properties);
        FileObject rootFile = this.createFileSystem(name.getScheme(), file, properties);
        return rootFile.resolveFile(name.getPath());
    }

    public synchronized FileObject createFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName rootName = file.getName();
        FileSystem fs = this.findFileSystem(rootName, null);
        if (fs == null) {
            fs = this.doCreateFileSystem(scheme, file, fileSystemOptions);
            this.addFileSystem(rootName, fs);
        }
        return fs.getRoot();
    }

    protected abstract FileSystem doCreateFileSystem(String var1, FileObject var2, FileSystemOptions var3) throws FileSystemException;
}

