/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileType;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.AbstractFileNameParser;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.LayeredFileName;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.UriParser;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.VfsComponentContext;

public class LayeredFileNameParser
extends AbstractFileNameParser {
    private static final LayeredFileNameParser INSTANCE = new LayeredFileNameParser();

    public static LayeredFileNameParser getInstance() {
        return INSTANCE;
    }

    public boolean encodeCharacter(char ch) {
        return super.encodeCharacter(ch) || ch == '!';
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuffer name = new StringBuffer();
        String scheme = UriParser.extractScheme(filename, name);
        String rootUriName = this.extractRootName(name);
        FileName rootUri = null;
        if (rootUriName != null) {
            rootUri = context.parseURI(rootUriName);
        }
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.fixSeparators(name);
        FileType fileType = UriParser.normalisePath(name);
        String path = name.toString();
        return new LayeredFileName(scheme, rootUri, path, fileType);
    }

    protected String extractRootName(StringBuffer uri) throws FileSystemException {
        int pos;
        int maxlen = uri.length();
        for (pos = maxlen - 1; pos > 0 && uri.charAt(pos) != '!'; --pos) {
        }
        if (pos == 0 && uri.charAt(pos) != '!') {
            pos = maxlen;
        }
        String prefix = uri.substring(0, pos);
        if (pos < maxlen) {
            uri.delete(0, pos + 1);
        } else {
            uri.setLength(0);
        }
        return prefix;
    }
}

