/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider;

import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileSystemException;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.FileType;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.VFS;
import com.crashlytics.dependency.reloc.org.apache.commons.vfs.provider.FileNameParser;

public final class UriParser {
    private static final char SEPARATOR_CHAR = '/';
    public static final char TRANS_SEPARATOR = '\\';

    private UriParser() {
    }

    public static String extractFirstElement(StringBuffer name) {
        int len = name.length();
        if (len < 1) {
            return null;
        }
        int startPos = 0;
        if (name.charAt(0) == '/') {
            startPos = 1;
        }
        for (int pos = startPos; pos < len; ++pos) {
            if (name.charAt(pos) != '/') continue;
            String elem = name.substring(startPos, pos);
            name.delete(startPos, pos + 1);
            return elem;
        }
        String elem = name.substring(startPos);
        name.setLength(0);
        return elem;
    }

    public static FileType normalisePath(StringBuffer path) throws FileSystemException {
        FileType fileType = FileType.FOLDER;
        if (path.length() == 0) {
            return fileType;
        }
        if (path.charAt(path.length() - 1) != '/') {
            fileType = FileType.FILE;
        }
        int startFirstElem = 0;
        if (path.charAt(0) == '/') {
            if (path.length() == 1) {
                return fileType;
            }
            startFirstElem = 1;
        }
        int startElem = startFirstElem;
        int maxlen = path.length();
        while (startElem < maxlen) {
            int endElem;
            for (endElem = startElem; endElem < maxlen && path.charAt(endElem) != '/'; ++endElem) {
            }
            int elemLen = endElem - startElem;
            if (elemLen == 0) {
                path.delete(endElem, endElem + 1);
                maxlen = path.length();
                continue;
            }
            if (elemLen == 1 && path.charAt(startElem) == '.') {
                path.delete(startElem, endElem + 1);
                maxlen = path.length();
                continue;
            }
            if (elemLen == 2 && path.charAt(startElem) == '.' && path.charAt(startElem + 1) == '.') {
                int pos;
                if (startElem == startFirstElem) {
                    throw new FileSystemException("vfs.provider/invalid-relative-path.error");
                }
                for (pos = startElem - 2; pos >= 0 && path.charAt(pos) != '/'; --pos) {
                }
                startElem = pos + 1;
                path.delete(startElem, endElem + 1);
                maxlen = path.length();
                continue;
            }
            startElem = endElem + 1;
        }
        if (!VFS.isUriStyle() && maxlen > 0 && path.charAt(maxlen - 1) == '/' && maxlen > 1) {
            path.delete(maxlen - 1, maxlen);
        }
        return fileType;
    }

    public static boolean fixSeparators(StringBuffer name) {
        boolean changed = false;
        int maxlen = name.length();
        for (int i = 0; i < maxlen; ++i) {
            char ch = name.charAt(i);
            if (ch != '\\') continue;
            name.setCharAt(i, '/');
            changed = true;
        }
        return changed;
    }

    public static String extractScheme(String uri) {
        return UriParser.extractScheme(uri, null);
    }

    public static String extractScheme(String uri, StringBuffer buffer) {
        if (buffer != null) {
            buffer.setLength(0);
            buffer.append(uri);
        }
        int maxPos = uri.length();
        for (int pos = 0; pos < maxPos; ++pos) {
            char ch = uri.charAt(pos);
            if (ch == ':') {
                String scheme = uri.substring(0, pos);
                if (buffer != null) {
                    buffer.delete(0, pos + 1);
                }
                return scheme.intern();
            }
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && (pos <= 0 || (ch < '0' || ch > '9') && ch != '+' && ch != '-' && ch != '.')) break;
        }
        return null;
    }

    public static String decode(String encodedStr) throws FileSystemException {
        if (encodedStr == null) {
            return null;
        }
        if (encodedStr.indexOf(37) < 0) {
            return encodedStr;
        }
        StringBuffer buffer = new StringBuffer(encodedStr);
        UriParser.decode(buffer, 0, buffer.length());
        return buffer.toString();
    }

    public static void decode(StringBuffer buffer, int offset, int length) throws FileSystemException {
        int index = offset;
        int count = length;
        while (count > 0) {
            char ch = buffer.charAt(index);
            if (ch == '%') {
                if (count < 3) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", buffer.substring(index, index + count));
                }
                int dig1 = Character.digit(buffer.charAt(index + 1), 16);
                int dig2 = Character.digit(buffer.charAt(index + 2), 16);
                if (dig1 == -1 || dig2 == -1) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", buffer.substring(index, index + 3));
                }
                char value = (char)(dig1 << 4 | dig2);
                buffer.setCharAt(index, value);
                buffer.delete(index + 1, index + 3);
                count -= 2;
            }
            --count;
            ++index;
        }
    }

    public static void appendEncoded(StringBuffer buffer, String unencodedValue, char[] reserved) {
        int offset = buffer.length();
        buffer.append(unencodedValue);
        UriParser.encode(buffer, offset, unencodedValue.length(), reserved);
    }

    public static void encode(StringBuffer buffer, int offset, int length, char[] reserved) {
        int index = offset;
        for (int count = length; count > 0; --count) {
            boolean match;
            char ch = buffer.charAt(index);
            boolean bl = match = ch == '%';
            if (reserved != null) {
                for (int i = 0; !match && i < reserved.length; ++i) {
                    if (ch != reserved[i]) continue;
                    match = true;
                }
            }
            if (match) {
                char[] digits = new char[]{Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
                buffer.setCharAt(index, '%');
                buffer.insert(index + 1, digits);
                index += 2;
            }
            ++index;
        }
    }

    public static String encode(String decodedStr) {
        return UriParser.encode(decodedStr, null);
    }

    public static String encode(String decodedStr, char[] reserved) {
        if (decodedStr == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(decodedStr);
        UriParser.encode(buffer, 0, buffer.length(), reserved);
        return buffer.toString();
    }

    public static String[] encode(String[] strings) {
        if (strings == null) {
            return null;
        }
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = UriParser.encode(strings[i]);
        }
        return strings;
    }

    public static void checkUriEncoding(String uri) throws FileSystemException {
        UriParser.decode(uri);
    }

    public static void canonicalizePath(StringBuffer buffer, int offset, int length, FileNameParser fileNameParser) throws FileSystemException {
        int index = offset;
        int count = length;
        while (count > 0) {
            char ch = buffer.charAt(index);
            if (ch == '%') {
                boolean match;
                if (count < 3) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", buffer.substring(index, index + count));
                }
                int dig1 = Character.digit(buffer.charAt(index + 1), 16);
                int dig2 = Character.digit(buffer.charAt(index + 2), 16);
                if (dig1 == -1 || dig2 == -1) {
                    throw new FileSystemException("vfs.provider/invalid-escape-sequence.error", buffer.substring(index, index + 3));
                }
                char value = (char)(dig1 << 4 | dig2);
                boolean bl = match = value == '%' || fileNameParser != null && fileNameParser.encodeCharacter(value);
                if (match) {
                    index += 2;
                    count -= 2;
                } else {
                    buffer.setCharAt(index, value);
                    buffer.delete(index + 1, index + 3);
                    count -= 2;
                }
            } else if (fileNameParser.encodeCharacter(ch)) {
                char[] digits = new char[]{Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
                buffer.setCharAt(index, '%');
                buffer.insert(index + 1, digits);
                index += 2;
            }
            --count;
            ++index;
        }
    }

    public static String extractQueryString(StringBuffer name) {
        for (int pos = 0; pos < name.length(); ++pos) {
            if (name.charAt(pos) != '?') continue;
            String queryString = name.substring(pos + 1);
            name.delete(pos, name.length());
            return queryString;
        }
        return null;
    }
}

